/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.Contextual;
import com.vicmatskiv.weaponlib.EntityBounceable;
import com.vicmatskiv.weaponlib.EntityProjectile;
import com.vicmatskiv.weaponlib.ModContext;
import com.vicmatskiv.weaponlib.SpreadableExposure;
import com.vicmatskiv.weaponlib.SpreadableExposureMessage;
import com.vicmatskiv.weaponlib.compatibility.CompatibilityProvider;
import com.vicmatskiv.weaponlib.compatibility.CompatibleEntityJoinWorldEvent;
import com.vicmatskiv.weaponlib.compatibility.CompatibleExposureCapability;
import com.vicmatskiv.weaponlib.compatibility.CompatibleLivingUpdateEvent;
import com.vicmatskiv.weaponlib.compatibility.CompatibleServerEventHandler;
import com.vicmatskiv.weaponlib.compatibility.CompatibleStartTrackingEvent;
import com.vicmatskiv.weaponlib.compatibility.CompatibleStopTrackingEvent;
import com.vicmatskiv.weaponlib.electronics.ItemHandheld;
import com.vicmatskiv.weaponlib.tracking.PlayerEntityTracker;
import com.vicmatskiv.weaponlib.tracking.SyncPlayerEntityTrackerMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerEventHandler
extends CompatibleServerEventHandler {
    private static final Logger logger = LogManager.getLogger(ServerEventHandler.class);
    private ModContext modContext;
    private String modId;

    public ServerEventHandler(ModContext modContext, String modId) {
        this.modContext = modContext;
        this.modId = modId;
    }

    @Override
    protected void onCompatibleLivingUpdateEvent(CompatibleLivingUpdateEvent e) {
        SpreadableExposure exposure;
        if (!CompatibilityProvider.compatibility.world((Entity)e.getEntity()).field_72995_K && (exposure = CompatibleExposureCapability.getExposure(e.getEntity(), SpreadableExposure.class)) != null) {
            ItemStack itemStack;
            boolean stillEffective = exposure.isEffective();
            exposure.update(e.getEntity());
            if (e.getEntity() instanceof EntityPlayerMP && System.currentTimeMillis() - exposure.getLastSyncTimestamp() > 500L) {
                this.modContext.getChannel().getChannel().sendTo((IMessage)new SpreadableExposureMessage(stillEffective ? exposure : null), (EntityPlayerMP)e.getEntity());
                exposure.setLastSyncTimestamp(System.currentTimeMillis());
            }
            if (!stillEffective) {
                CompatibleExposureCapability.removeExposure(e.getEntity(), SpreadableExposure.class);
            }
            if ((itemStack = CompatibilityProvider.compatibility.getHeldItemMainHand(e.getEntityLiving())) != null && itemStack.func_77973_b() instanceof ItemHandheld) {
                CompatibilityProvider.compatibility.ensureTagCompound(itemStack);
                NBTTagCompound nbt = CompatibilityProvider.compatibility.getTagCompound(itemStack);
                nbt.func_74776_a("dose", exposure.getLastDose());
            }
        }
    }

    @Override
    protected void onCompatibleItemToss(ItemTossEvent itemTossEvent) {
    }

    @Override
    protected void onCompatibleEntityJoinWorld(CompatibleEntityJoinWorldEvent e) {
        if (e.getEntity() instanceof Contextual) {
            ((Contextual)e.getEntity()).setContext(this.modContext);
        }
        if (e.getEntity() instanceof EntityPlayerMP && !e.getWorld().field_72995_K) {
            logger.debug("Player {} joined the world", new Object[]{e.getEntity()});
            PlayerEntityTracker tracker = PlayerEntityTracker.getTracker((EntityLivingBase)((EntityPlayer)e.getEntity()));
            if (tracker != null) {
                this.modContext.getChannel().getChannel().sendTo((IMessage)new SyncPlayerEntityTrackerMessage(tracker), (EntityPlayerMP)e.getEntity());
            }
        }
    }

    @Override
    protected void onCompatiblePlayerStartedTracking(CompatibleStartTrackingEvent e) {
        if (e.getTarget() instanceof EntityProjectile || e.getTarget() instanceof EntityBounceable) {
            return;
        }
        PlayerEntityTracker tracker = PlayerEntityTracker.getTracker((EntityLivingBase)((EntityPlayer)e.getEntity()));
        if (tracker != null && tracker.updateTrackableEntity(e.getTarget())) {
            logger.debug("Player {} started tracking {} with uuid {}", new Object[]{e.getPlayer(), e.getTarget(), e.getTarget().func_110124_au()});
            this.modContext.getChannel().getChannel().sendTo((IMessage)new SyncPlayerEntityTrackerMessage(tracker), (EntityPlayerMP)e.getPlayer());
        }
    }

    @Override
    protected void onCompatiblePlayerStoppedTracking(CompatibleStopTrackingEvent e) {
        if (e.getTarget() instanceof EntityProjectile || e.getTarget() instanceof EntityBounceable) {
            return;
        }
        PlayerEntityTracker tracker = PlayerEntityTracker.getTracker((EntityLivingBase)((EntityPlayer)e.getEntity()));
        if (tracker != null && tracker.updateTrackableEntity(e.getTarget())) {
            logger.debug("Player {} stopped tracking {}", new Object[]{e.getPlayer(), e.getTarget()});
            this.modContext.getChannel().getChannel().sendTo((IMessage)new SyncPlayerEntityTrackerMessage(tracker), (EntityPlayerMP)e.getPlayer());
        }
    }

    @Override
    protected void onCompatibleLivingDeathEvent(LivingDeathEvent e) {
    }

    @Override
    public String getModId() {
        return this.modId;
    }
}

