/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.AttachmentCategory;
import com.vicmatskiv.weaponlib.CompatibleAttachment;
import com.vicmatskiv.weaponlib.EntitySpreadable;
import com.vicmatskiv.weaponlib.ExposureProtection;
import com.vicmatskiv.weaponlib.ItemAttachment;
import com.vicmatskiv.weaponlib.ModContext;
import com.vicmatskiv.weaponlib.compatibility.CompatibilityProvider;
import com.vicmatskiv.weaponlib.compatibility.CompatibleCustomArmor;
import com.vicmatskiv.weaponlib.compatibility.CompatibleEntityEquipmentSlot;
import com.vicmatskiv.weaponlib.compatibility.CompatibleSound;
import com.vicmatskiv.weaponlib.model.ModelBaseRendererWrapper;
import com.vicmatskiv.weaponlib.model.WrappableModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class CustomArmor
extends CompatibleCustomArmor
implements ExposureProtection {
    private static final String ACTIVE_ATTACHMENT_TAG = "ActiveAttachments";
    private Map<ItemAttachment<CustomArmor>, CompatibleAttachment<CustomArmor>> compatibleAttachments = new HashMap<ItemAttachment<CustomArmor>, CompatibleAttachment<CustomArmor>>();
    private boolean hasNightVision;
    private float exposureReductionFactor;
    private CompatibleSound breathingSound;
    private CompatibleEntityEquipmentSlot compatibleEquipmentType;

    private CustomArmor(String modId, ItemArmor.ArmorMaterial material, int renderIndex, CompatibleEntityEquipmentSlot armorType, String iconName, String textureName, ModelBiped model, String hudTextureName) {
        super(modId, material, renderIndex, armorType, iconName.toLowerCase(), textureName, model, hudTextureName);
        this.compatibleEquipmentType = armorType;
    }

    @Override
    public String getHudTexture() {
        return this.modId + ":" + "textures/hud/" + this.hudTextureName + ".png";
    }

    public void changeAttachment(AttachmentCategory attachmentCategory, ItemStack itemStack, EntityPlayer player) {
        ItemAttachment<CustomArmor> nextAttachment;
        CompatibilityProvider.compatibility.ensureTagCompound(itemStack);
        int[] activeAttachmentsIds = this.ensureActiveAttachments(itemStack);
        int activeAttachmentIdForThisCategory = activeAttachmentsIds[attachmentCategory.ordinal()];
        ItemAttachment item = null;
        if (activeAttachmentIdForThisCategory > 0 && (item = (ItemAttachment)Item.func_150899_d((int)activeAttachmentIdForThisCategory)) != null && item.getRemove() != null) {
            item.getRemove().apply(item, this, (EntityLivingBase)player);
        }
        if ((nextAttachment = this.nextCompatibleAttachment(attachmentCategory, item, player)) != null && nextAttachment.getApply() != null) {
            nextAttachment.getApply().apply(nextAttachment, this, (EntityLivingBase)player);
        }
        activeAttachmentsIds[attachmentCategory.ordinal()] = Item.func_150891_b(nextAttachment);
        CompatibilityProvider.compatibility.getTagCompound(itemStack).func_74783_a(ACTIVE_ATTACHMENT_TAG, activeAttachmentsIds);
    }

    private ItemAttachment<CustomArmor> nextCompatibleAttachment(AttachmentCategory category, Item currentAttachment, EntityPlayer player) {
        ItemAttachment nextAttachment = null;
        boolean foundCurrent = false;
        for (int i = 0; i < 36; ++i) {
            ItemAttachment compatibleAttachment;
            ItemStack itemStack = player.field_71071_by.func_70301_a(i);
            if (itemStack == null || !(itemStack.func_77973_b() instanceof ItemAttachment) || (compatibleAttachment = (ItemAttachment)itemStack.func_77973_b()).getCategory() != category) continue;
            if (foundCurrent || currentAttachment == null) {
                nextAttachment = compatibleAttachment;
                break;
            }
            if (currentAttachment != compatibleAttachment) continue;
            foundCurrent = true;
        }
        return nextAttachment;
    }

    public ItemAttachment<CustomArmor> getActiveAttachment(ItemStack itemStack, AttachmentCategory category) {
        int[] activeAttachmentsIds;
        CompatibilityProvider.compatibility.ensureTagCompound(itemStack);
        ItemAttachment<CustomArmor> itemAttachment = null;
        for (int activeIndex : activeAttachmentsIds = this.ensureActiveAttachments(itemStack)) {
            CompatibleAttachment<CustomArmor> compatibleAttachment;
            Item item;
            if (activeIndex == 0 || !((item = Item.func_150899_d((int)activeIndex)) instanceof ItemAttachment) || (compatibleAttachment = this.compatibleAttachments.get(item)) == null || category != compatibleAttachment.getAttachment().getCategory()) continue;
            itemAttachment = compatibleAttachment.getAttachment();
            break;
        }
        return itemAttachment;
    }

    public List<CompatibleAttachment<CustomArmor>> getActiveAttachments(ItemStack itemStack) {
        int[] activeAttachmentsIds;
        CompatibilityProvider.compatibility.ensureTagCompound(itemStack);
        ArrayList<CompatibleAttachment<CustomArmor>> activeAttachments = new ArrayList<CompatibleAttachment<CustomArmor>>();
        for (int activeIndex : activeAttachmentsIds = this.ensureActiveAttachments(itemStack)) {
            CompatibleAttachment<CustomArmor> compatibleAttachment;
            Item item;
            if (activeIndex == 0 || !((item = Item.func_150899_d((int)activeIndex)) instanceof ItemAttachment) || (compatibleAttachment = this.compatibleAttachments.get(item)) == null) continue;
            activeAttachments.add(compatibleAttachment);
        }
        return activeAttachments;
    }

    private int[] ensureActiveAttachments(ItemStack itemStack) {
        int[] activeAttachmentsIds = CompatibilityProvider.compatibility.getTagCompound(itemStack).func_74759_k(ACTIVE_ATTACHMENT_TAG);
        if (activeAttachmentsIds == null || activeAttachmentsIds.length != AttachmentCategory.values.length) {
            activeAttachmentsIds = new int[AttachmentCategory.values.length];
            CompatibilityProvider.compatibility.getTagCompound(itemStack).func_74783_a(ACTIVE_ATTACHMENT_TAG, activeAttachmentsIds);
            for (CompatibleAttachment<CustomArmor> attachment : this.compatibleAttachments.values()) {
                if (!attachment.isDefault()) continue;
                activeAttachmentsIds[attachment.getAttachment().getCategory().ordinal()] = Item.func_150891_b(attachment.getAttachment());
            }
        }
        return activeAttachmentsIds;
    }

    public static boolean isActiveAttachment(ItemStack itemStack, ItemAttachment<CustomArmor> attachment) {
        CustomArmor armor = (CustomArmor)itemStack.func_77973_b();
        int[] activeAttachmentsIds = armor.ensureActiveAttachments(itemStack);
        return Arrays.stream(activeAttachmentsIds).anyMatch(attachmentId -> attachment == Item.func_150899_d((int)attachmentId));
    }

    public boolean hasNightVision() {
        return this.hasNightVision;
    }

    @Override
    public Function<Float, Float> getAbsorbFunction(EntitySpreadable spreadable) {
        return dose -> Float.valueOf(dose.floatValue() * (1.0f - this.exposureReductionFactor));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public CompatibleEntityEquipmentSlot getCompatibleEquipmentSlot() {
        return this.compatibleEquipmentType;
    }

    public static class Builder {
        private String modId;
        private String textureName;
        private String iconName;
        private ItemArmor.ArmorMaterial material;
        private String unlocalizedName;
        private ModelBiped bootsModel;
        private ModelBiped chestModel;
        private ModelBiped helmetModel;
        private String modelClassName;
        private String hudTextureName;
        private Map<ItemAttachment<CustomArmor>, CompatibleAttachment<CustomArmor>> compatibleAttachments = new HashMap<ItemAttachment<CustomArmor>, CompatibleAttachment<CustomArmor>>();
        private CreativeTabs creativeTab;
        private boolean nightVision;
        private float exposureReductionFactor;
        private String breathingSound;

        public Builder withModId(String modId) {
            this.modId = modId;
            return this;
        }

        public Builder withCreativeTab(CreativeTabs creativeTab) {
            this.creativeTab = creativeTab;
            return this;
        }

        public Builder withTextureName(String textureName) {
            this.textureName = textureName.toLowerCase();
            return this;
        }

        public Builder withMaterial(ItemArmor.ArmorMaterial material) {
            this.material = material;
            return this;
        }

        public Builder withUnlocalizedName(String unlocalizedName) {
            this.unlocalizedName = unlocalizedName;
            return this;
        }

        public Builder withModelClass(String modelClass) {
            this.modelClassName = modelClass;
            return this;
        }

        public Builder withHudTextureName(String hudTextureName) {
            this.hudTextureName = hudTextureName.toLowerCase();
            return this;
        }

        public Builder withNightVision(boolean nightVision) {
            this.nightVision = nightVision;
            return this;
        }

        public Builder withExposureReductionFactor(float exposureReductionFactor) {
            this.exposureReductionFactor = exposureReductionFactor;
            return this;
        }

        public Builder withBreathingSound(String sound) {
            this.breathingSound = sound.toLowerCase();
            return this;
        }

        public Builder withCompatibleAttachment(AttachmentCategory category, ModelBase attachmentModel, String textureName, Consumer<ModelBase> positioner) {
            ItemAttachment item = new ItemAttachment(this.modId, category, attachmentModel, textureName, null);
            this.compatibleAttachments.put(item, new CompatibleAttachment(item, positioner));
            return this;
        }

        public void build(boolean isClient) {
            if (isClient) {
                // empty if block
            }
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            String unlocalizedHelmetName = this.unlocalizedName + "_helmet";
            CustomArmor armorHelmet = new CustomArmor(this.modId, this.material, 4, CompatibleEntityEquipmentSlot.HEAD, unlocalizedHelmetName, this.textureName, this.chestModel, this.hudTextureName);
            if (this.creativeTab != null) {
                armorHelmet.func_77637_a(this.creativeTab);
            }
            armorHelmet.func_77655_b(unlocalizedHelmetName);
            CompatibilityProvider.compatibility.registerItem((Item)armorHelmet, unlocalizedHelmetName.toLowerCase());
            String unlocalizedChestName = this.unlocalizedName + "_chest";
            CustomArmor armorChest = new CustomArmor(this.modId, this.material, 4, CompatibleEntityEquipmentSlot.CHEST, unlocalizedChestName, this.textureName, this.chestModel, this.hudTextureName);
            if (this.creativeTab != null) {
                armorChest.func_77637_a(this.creativeTab);
            }
            armorChest.func_77655_b(unlocalizedChestName);
            CompatibilityProvider.compatibility.registerItem((Item)armorChest, unlocalizedChestName.toLowerCase());
            String unlocalizedBootsName = this.unlocalizedName + "_boots";
            CustomArmor armorBoots = new CustomArmor(this.modId, this.material, 4, CompatibleEntityEquipmentSlot.FEET, unlocalizedBootsName, this.textureName, this.bootsModel, this.hudTextureName);
            if (armorBoots != null) {
                armorBoots.func_77637_a(this.creativeTab);
            }
            armorBoots.func_77655_b(unlocalizedBootsName);
            CompatibilityProvider.compatibility.registerItem((Item)armorBoots, unlocalizedBootsName.toLowerCase());
        }

        public CustomArmor buildHelmet(ModContext context) {
            if (context.isClient() && this.helmetModel == null) {
                this.helmetModel = HelmetModelFactory.create(this.modelClassName);
            }
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            String unlocalizedHelmetName = this.unlocalizedName + "_helmet";
            CustomArmor armorHelmet = new CustomArmor(this.modId, this.material, 4, CompatibleEntityEquipmentSlot.HEAD, unlocalizedHelmetName, this.textureName, this.helmetModel, this.hudTextureName);
            if (this.nightVision) {
                armorHelmet.hasNightVision = true;
            }
            armorHelmet.exposureReductionFactor = this.exposureReductionFactor;
            armorHelmet.func_77655_b(unlocalizedHelmetName);
            armorHelmet.breathingSound = context.registerSound(this.breathingSound);
            CompatibilityProvider.compatibility.registerItem((Item)armorHelmet, unlocalizedHelmetName.toLowerCase());
            if (this.creativeTab != null) {
                armorHelmet.func_77637_a(this.creativeTab);
            }
            return armorHelmet;
        }

        public CustomArmor buildChest(boolean isClient) {
            if (isClient && this.chestModel == null) {
                this.chestModel = ChestModelFactory.createModel(this.modelClassName);
            }
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            String unlocalizedChestName = this.unlocalizedName + "_chest";
            CustomArmor armorChest = new CustomArmor(this.modId, this.material, 4, CompatibleEntityEquipmentSlot.CHEST, unlocalizedChestName, this.textureName, this.chestModel, this.hudTextureName);
            if (this.creativeTab != null) {
                armorChest.func_77637_a(this.creativeTab);
            }
            armorChest.func_77655_b(unlocalizedChestName);
            CompatibilityProvider.compatibility.registerItem((Item)armorChest, unlocalizedChestName.toLowerCase());
            return armorChest;
        }

        public CustomArmor buildBoots(boolean isClient) {
            if (isClient && this.bootsModel == null) {
                this.bootsModel = BootsModelFactory.createModel(this.modelClassName);
            }
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            String unlocalizedBootsName = this.unlocalizedName + "_boots";
            CustomArmor armorBoots = new CustomArmor(this.modId, this.material, 4, CompatibleEntityEquipmentSlot.FEET, unlocalizedBootsName, this.textureName, this.bootsModel, this.hudTextureName);
            if (this.creativeTab != null) {
                armorBoots.func_77637_a(this.creativeTab);
            }
            armorBoots.func_77655_b(unlocalizedBootsName);
            CompatibilityProvider.compatibility.registerItem((Item)armorBoots, unlocalizedBootsName.toLowerCase());
            return armorBoots;
        }

        private static final class BootsModelFactory {
            private BootsModelFactory() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private static ModelBiped createModel(String modelClassName) {
                ModelBiped bootsModel = null;
                try {
                    Class<?> modelClass = Class.forName(modelClassName);
                    if (ModelBiped.class.isAssignableFrom(modelClass)) {
                        return (ModelBiped)modelClass.newInstance();
                    }
                    if (!ModelBase.class.isAssignableFrom(modelClass)) return bootsModel;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new IllegalStateException("Missing boots model", e);
                }
                return bootsModel;
            }
        }

        private static class HelmetModelFactory {
            private HelmetModelFactory() {
            }

            private static ModelBiped create(String modelClassName) {
                ModelBiped helmetModel = null;
                try {
                    final Class<?> modelClass = Class.forName(modelClassName);
                    if (ModelBiped.class.isAssignableFrom(modelClass)) {
                        helmetModel = (ModelBiped)modelClass.newInstance();
                    } else if (ModelBase.class.isAssignableFrom(modelClass)) {
                        helmetModel = new ModelBiped(){
                            {
                                this.field_78116_c = new ModelBaseRendererWrapper((WrappableModel)((Object)modelClass.newInstance()));
                                this.field_178720_f.field_78807_k = true;
                            }
                        };
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new IllegalStateException("Missing helmet model", e);
                }
                return helmetModel;
            }
        }

        private static class ChestModelFactory {
            private ChestModelFactory() {
            }

            private static ModelBiped createModel(String modelClassName) {
                try {
                    return (ModelBiped)Class.forName(modelClassName).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new IllegalStateException("Missing chest model", e);
                }
            }
        }
    }
}

