/*
 * Decompiled with CFR 0.152.
 */
package net.creativerealmsmc.conquest.renderer.entity;

import net.creativerealmsmc.conquest.entity.painting.Art;
import net.creativerealmsmc.conquest.entity.painting.PaintingBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class PaintingRender
extends Render<PaintingBase> {
    private final ResourceLocation paintingTexture;

    protected PaintingRender(RenderManager renderManager, String name) {
        super(renderManager);
        this.paintingTexture = new ResourceLocation("conquest", "textures/paintings/" + name + ".png");
    }

    public void doRender(PaintingBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)(180.0f - entityYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179091_B();
        this.func_180548_c((Entity)entity);
        Art art = entity.art;
        float f = 0.0625f;
        GlStateManager.func_179152_a((float)f, (float)f, (float)f);
        this.renderPainting(entity, art.sizeX, art.sizeY, art.offsetX, art.offsetY);
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(PaintingBase entity) {
        return this.paintingTexture;
    }

    private void renderPainting(PaintingBase painting, int width, int height, int textureU, int textureV) {
        float xCenter = (float)(-width) / 2.0f;
        float yCenter = (float)(-height) / 2.0f;
        float f2 = 0.3f;
        for (int i = 0; i < width / 16; ++i) {
            for (int j = 0; j < height / 16; ++j) {
                float xMax = xCenter + (float)((i + 1) * 16);
                float xMin = xCenter + (float)(i * 16);
                float yMax = yCenter + (float)((j + 1) * 16);
                float yMin = yCenter + (float)(j * 16);
                this.setLightmap(painting, (xMax + xMin) / 2.0f, (yMax + yMin) / 2.0f);
                Tessellator tessellator = Tessellator.func_178181_a();
                VertexBuffer buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
                float txMin = (float)(textureU + width - i * 16) / 256.0f;
                float txMax = (float)(textureU + width - (i + 1) * 16) / 256.0f;
                float tyMin = (float)(textureV + height - j * 16) / 256.0f;
                float tyMax = (float)(textureV + height - (j + 1) * 16) / 256.0f;
                buffer.func_181662_b((double)xMax, (double)yMin, (double)f2).func_187315_a((double)txMax, (double)tyMin).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                buffer.func_181662_b((double)xMin, (double)yMin, (double)f2).func_187315_a((double)txMin, (double)tyMin).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                buffer.func_181662_b((double)xMin, (double)yMax, (double)f2).func_187315_a((double)txMin, (double)tyMax).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                buffer.func_181662_b((double)xMax, (double)yMax, (double)f2).func_187315_a((double)txMax, (double)tyMax).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                float txMinReverse = txMin;
                float txMaxReverse = txMax;
                float tyMinReverse = tyMax;
                float tyMaxReverse = tyMin;
                buffer.func_181662_b((double)xMax, (double)yMax, (double)f2).func_187315_a((double)txMaxReverse, (double)tyMinReverse).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                buffer.func_181662_b((double)xMin, (double)yMax, (double)f2).func_187315_a((double)txMinReverse, (double)tyMinReverse).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                buffer.func_181662_b((double)xMin, (double)yMin, (double)f2).func_187315_a((double)txMinReverse, (double)tyMaxReverse).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                buffer.func_181662_b((double)xMax, (double)yMin, (double)f2).func_187315_a((double)txMaxReverse, (double)tyMaxReverse).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                tessellator.func_78381_a();
            }
        }
    }

    private void setLightmap(PaintingBase painting, float p_77008_2_, float p_77008_3_) {
        int i = MathHelper.func_76128_c((double)painting.field_70165_t);
        int j = MathHelper.func_76128_c((double)(painting.field_70163_u + (double)(p_77008_3_ / 16.0f)));
        int k = MathHelper.func_76128_c((double)painting.field_70161_v);
        EnumFacing enumfacing = painting.field_174860_b;
        if (enumfacing == EnumFacing.NORTH) {
            i = MathHelper.func_76128_c((double)(painting.field_70165_t + (double)(p_77008_2_ / 16.0f)));
        }
        if (enumfacing == EnumFacing.WEST) {
            k = MathHelper.func_76128_c((double)(painting.field_70161_v - (double)(p_77008_2_ / 16.0f)));
        }
        if (enumfacing == EnumFacing.SOUTH) {
            i = MathHelper.func_76128_c((double)(painting.field_70165_t - (double)(p_77008_2_ / 16.0f)));
        }
        if (enumfacing == EnumFacing.EAST) {
            k = MathHelper.func_76128_c((double)(painting.field_70161_v + (double)(p_77008_2_ / 16.0f)));
        }
        int l = this.field_76990_c.field_78722_g.func_175626_b(new BlockPos(i, j, k), 0);
        int i1 = l % 65536;
        int j1 = l / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)i1, (float)j1);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static class Factory
    implements IRenderFactory<PaintingBase> {
        private final String name;

        public Factory(String name) {
            this.name = name;
        }

        public Render<? super PaintingBase> createRenderFor(RenderManager manager) {
            return new PaintingRender(manager, this.name);
        }
    }
}

