/*
 * Decompiled with CFR 0.152.
 */
package net.creativerealmsmc.conquest.items;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.creativerealmsmc.conquest.entity.painting.Art;
import net.creativerealmsmc.conquest.entity.painting.IPaintingSupplier;
import net.creativerealmsmc.conquest.entity.painting.PaintingBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHangingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PaintingItem
extends ItemHangingEntity {
    private static final Map<String, PaintingItem> paintingItemMap = new HashMap<String, PaintingItem>();
    private static final List<PaintingItem> orderedItems = new ArrayList<PaintingItem>();
    private final IPaintingSupplier paintingCreator;
    private final String name;
    private static Comparator<PaintingItem> comparator = new Comparator<PaintingItem>(){

        @Override
        public int compare(PaintingItem o1, PaintingItem o2) {
            return o1.name.compareTo(o2.name);
        }
    };

    public PaintingItem(Class<? extends PaintingBase> entityClass, IPaintingSupplier paintingCreator, String domain, String name) {
        super(entityClass);
        this.name = name;
        this.paintingCreator = paintingCreator;
        this.func_77655_b(name);
        this.setRegistryName(domain + ":" + name);
        this.func_77625_d(1);
        paintingItemMap.put(name, this);
        orderedItems.add(this);
        Collections.sort(orderedItems, comparator);
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        if (tab == CreativeTabs.field_78027_g) {
            for (Art art : Art.values()) {
                ItemStack stack = new ItemStack(itemIn, 1, art.index());
                subItems.add(stack);
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + this.getArtName(stack);
    }

    public String getName() {
        return this.name;
    }

    public String getArtName(ItemStack itemStack) {
        return Art.fromId((int)itemStack.func_77960_j()).shapeId;
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (side != EnumFacing.DOWN && side != EnumFacing.UP) {
            BlockPos blockpos = pos.func_177972_a(side);
            Art art = Art.fromId(stack.func_77960_j());
            if (!player.func_175151_a(blockpos, side, stack)) {
                return EnumActionResult.FAIL;
            }
            PaintingBase painting = this.paintingCreator.createEntity(world, blockpos, side, art);
            if (painting != null) {
                if (!world.field_72995_K && world.func_72838_d((Entity)painting)) {
                    painting.func_184523_o();
                }
                --stack.field_77994_a;
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public static Collection<PaintingItem> getItems() {
        return Collections.unmodifiableCollection(orderedItems);
    }

    public static Collection<String> getPaintingIds() {
        return Collections.unmodifiableCollection(paintingItemMap.keySet());
    }

    public static Collection<String> getLocalizedNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (PaintingItem item : paintingItemMap.values()) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            item.func_150895_a((Item)item, CreativeTabs.field_78027_g, list);
            for (ItemStack stack : list) {
                names.add(stack.func_82833_r().toLowerCase());
            }
        }
        return names;
    }

    public static PaintingItem getPainting(String name) {
        return paintingItemMap.get(name);
    }
}

