/*
 * Decompiled with CFR 0.152.
 */
package net.creativerealmsmc.conquest.init;

import net.creativerealmsmc.conquest.init.MetaBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModColourManager {
    private static final Minecraft minecraft = Minecraft.func_71410_x();

    public static void registerColourHandlers() {
        BlockColors blockColors = minecraft.func_184125_al();
        ItemColors itemColors = minecraft.getItemColors();
        ModColourManager.registerBlockColourHandlers(blockColors);
        ModColourManager.registerItemColourHandlers(blockColors, itemColors);
    }

    private static void registerBlockColourHandlers(BlockColors blockColors) {
        IBlockColor grassColourHandler = new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, int tintIndex) {
                if (blockAccess != null && pos != null) {
                    return BiomeColorHelper.func_180286_a((IBlockAccess)blockAccess, (BlockPos)pos);
                }
                return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
            }
        };
        blockColors.func_186722_a(grassColourHandler, new Block[]{MetaBlocks.plants_nocollisionbiome_1});
        blockColors.func_186722_a(grassColourHandler, new Block[]{MetaBlocks.vine_jungle});
        blockColors.func_186722_a(grassColourHandler, new Block[]{MetaBlocks.vine_ivy});
        blockColors.func_186722_a(grassColourHandler, new Block[]{MetaBlocks.vine_moss});
        blockColors.func_186722_a(grassColourHandler, new Block[]{MetaBlocks.grass_layer_1});
        blockColors.func_186722_a(grassColourHandler, new Block[]{MetaBlocks.leaves_fullbiome_1});
        blockColors.func_186722_a(grassColourHandler, new Block[]{MetaBlocks.grass_full_1});
    }

    private static void registerItemColourHandlers(final BlockColors blockColors, ItemColors itemColors) {
        IItemColor itemBlockColourHandler = new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                IBlockState iblockstate = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
                return blockColors.func_186724_a(iblockstate, null, null, tintIndex);
            }
        };
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{MetaBlocks.plants_nocollisionbiome_1});
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{MetaBlocks.vine_jungle});
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{MetaBlocks.vine_ivy});
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{MetaBlocks.vine_moss});
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{MetaBlocks.grass_layer_1});
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{MetaBlocks.leaves_fullbiome_1});
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{MetaBlocks.grass_full_1});
    }
}

