/*
 * Decompiled with CFR 0.152.
 */
package net.creativerealmsmc.conquest.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import net.creativerealmsmc.conquest.entity.painting.Art;
import net.creativerealmsmc.conquest.items.PaintingItem;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.StringUtils;

public class PaintingCommand
implements ICommand {
    public String func_71517_b() {
        return "paint";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/paint <painting_id> <art_id>";
    }

    public List<String> func_71514_a() {
        return Collections.singletonList("paint");
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayerMP)) {
            return;
        }
        if (args.length > 0) {
            String input = StringUtils.join((Object[])args, (String)" ");
            ItemStack stack = null;
            block0: for (String id : PaintingItem.getPaintingIds()) {
                PaintingItem item = PaintingItem.getPainting(id);
                for (Art art : Art.values()) {
                    ItemStack test = new ItemStack((Item)item, 1, art.index());
                    String name0 = item.func_77653_i(test);
                    if (name0.equalsIgnoreCase(input)) {
                        stack = test;
                        break block0;
                    }
                    String name1 = id + " " + art.shapeId;
                    if (!name1.equalsIgnoreCase(input)) continue;
                    stack = test;
                    break block0;
                }
            }
            if (stack != null) {
                EntityPlayerMP player = (EntityPlayerMP)sender;
                player.field_71071_by.func_70441_a(stack);
                return;
            }
            throw new CommandException(String.format("Invalid painting: '%s'", input), new Object[0]);
        }
        throw new CommandException("Not enough arguments!", new Object[0]);
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(0, this.func_71517_b());
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length > 0) {
            LinkedHashSet<String> results = new LinkedHashSet<String>();
            String first = args[0].toLowerCase();
            String joined = StringUtils.join((Object[])args, (String)" ").toLowerCase();
            PaintingCommand.addMatches(first, PaintingItem.getPaintingIds().toArray(), results, true);
            PaintingCommand.addMatches(joined, PaintingItem.getLocalizedNames().toArray(), results, false);
            if (args.length > 1) {
                PaintingCommand.addMatches(args[args.length - 1].toLowerCase(), (Object[])Art.values(), results, false);
            }
            ArrayList<String> list = new ArrayList<String>(results);
            Collections.sort(list);
            return list;
        }
        return Collections.emptyList();
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public int compareTo(ICommand o) {
        return this.func_71517_b().compareTo(o.func_71517_b());
    }

    private static void addMatches(String input, Object[] array, Collection<String> results, boolean allowEmpty) {
        for (Object o : array) {
            if (!o.toString().toLowerCase().startsWith(input)) continue;
            results.add(o.toString());
        }
    }
}

