/*
 * Decompiled with CFR 0.152.
 */
package net.creativerealmsmc.conquest.blocks.MetaBlocks;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.creativerealmsmc.conquest.items.IMetaBlockName;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFenceGateMeta
extends BlockHorizontal
implements IMetaBlockName {
    public static final PropertyBool OPEN = PropertyBool.func_177716_a((String)"open");
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    protected static final AxisAlignedBB AABB_COLLIDE_ZAXIS = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    protected static final AxisAlignedBB AABB_COLLIDE_XAXIS = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_CLOSED_SELECTED_ZAXIS = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.5, 0.625);
    protected static final AxisAlignedBB AABB_CLOSED_SELECTED_XAXIS = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.5, 1.0);
    private boolean canSustainPlant;

    public BlockFenceGateMeta(String nameIn, String unlocalizedNameIn, Material materialIn, float hardness, float resistance, SoundType sound, float lightLevel, String tool, int toolLevel, boolean canSustainPlant, CreativeTabs tab) {
        super(materialIn);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.ALPHA)).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName(nameIn);
        this.func_149663_c(unlocalizedNameIn);
        this.func_149647_a(tab);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.func_149672_a(sound);
        this.func_149715_a(lightLevel);
        if (tool != null) {
            this.setHarvestLevel(tool, toolLevel);
        }
        this.canSustainPlant = canSustainPlant;
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return EnumType.values()[stack.func_77952_i()].name().toLowerCase(Locale.ENGLISH);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return this.canSustainPlant;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ((EnumFacing)(state = this.func_176221_a(state, source, pos)).func_177229_b((IProperty)field_185512_D)).func_176740_k() == EnumFacing.Axis.X ? AABB_COLLIDE_XAXIS : AABB_COLLIDE_ZAXIS;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing.Axis enumfacing$axis = ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176740_k();
        return state;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return (Boolean)blockState.func_177229_b((IProperty)OPEN) != false ? field_185506_k : (((EnumFacing)blockState.func_177229_b((IProperty)field_185512_D)).func_176740_k() == EnumFacing.Axis.Z ? AABB_CLOSED_SELECTED_ZAXIS : AABB_CLOSED_SELECTED_XAXIS);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return (Boolean)worldIn.func_180495_p(pos).func_177229_b((IProperty)OPEN);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)).func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            state = state.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false));
            worldIn.func_180501_a(pos, state, 10);
        } else {
            EnumFacing enumfacing = EnumFacing.func_176733_a((double)playerIn.field_70177_z);
            if (state.func_177229_b((IProperty)field_185512_D) == enumfacing.func_176734_d()) {
                state = state.func_177226_a((IProperty)field_185512_D, (Comparable)enumfacing);
            }
            state = state.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(true));
            worldIn.func_180501_a(pos, state, 10);
        }
        worldIn.func_180498_a(playerIn, (Boolean)state.func_177229_b((IProperty)OPEN) != false ? 1008 : 1014, pos, 0);
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        boolean flag;
        if (!worldIn.field_72995_K && ((flag = worldIn.func_175640_z(pos)) || blockIn.func_176223_P().func_185897_m())) {
            if (flag && !((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(true)));
                worldIn.func_180498_a((EntityPlayer)null, 1008, pos, 0);
            } else if (!flag && ((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)));
                worldIn.func_180498_a((EntityPlayer)null, 1014, pos, 0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (EnumType enumtype : EnumType.values()) {
            list.add(new ItemStack(itemIn, 1, enumtype.getMetadata()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)((meta & 6) >> 1))).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf((meta & 8) != 0)).func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta & 1)));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
        i |= ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b() << 1;
        if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, OPEN, VARIANT});
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public static enum EnumType implements IStringSerializable
    {
        ALPHA(0, "alpha"),
        BRAVO(1, "bravo");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int metaIn, String nameIn) {
            this.meta = metaIn;
            this.name = nameIn;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta > META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType enumtype;
                EnumType.META_LOOKUP[enumtype.getMetadata()] = enumtype = enumTypeArray[i];
            }
        }
    }
}

