/*
 * Decompiled with CFR 0.152.
 */
package net.creativerealmsmc.conquest.blocks.MetaBlocks;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.creativerealmsmc.conquest.items.IMetaBlockName;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBeamMeta
extends BlockHorizontal
implements IMetaBlockName {
    public static final PropertyBool ACTIVATED = PropertyBool.func_177716_a((String)"activated");
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    protected static final AxisAlignedBB AABB_NORTH_OFF = new AxisAlignedBB(0.0, 0.0, 0.3125, 0.25, 1.0, 0.6875);
    protected static final AxisAlignedBB AABB_SOUTH_OFF = new AxisAlignedBB(0.75, 0.0, 0.3125, 1.0, 1.0, 0.6875);
    protected static final AxisAlignedBB AABB_WEST_OFF = new AxisAlignedBB(0.3125, 0.0, 0.75, 0.6875, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_EAST_OFF = new AxisAlignedBB(0.3125, 0.0, 0.0, 0.6875, 1.0, 0.25);
    protected static final AxisAlignedBB AABB_NORTH_ON = new AxisAlignedBB(0.0, 0.0, 0.3125, 1.0, 1.0, 0.6875);
    protected static final AxisAlignedBB AABB_SOUTH_ON = new AxisAlignedBB(0.0, 0.0, 0.3125, 1.0, 1.0, 0.6875);
    protected static final AxisAlignedBB AABB_WEST_ON = new AxisAlignedBB(0.3125, 0.0, 0.0, 0.6875, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_EAST_ON = new AxisAlignedBB(0.3125, 0.0, 0.0, 0.6875, 1.0, 1.0);
    private boolean canSustainPlant;

    public BlockBeamMeta(String nameIn, String unlocalizedNameIn, Material materialIn, float hardness, float resistance, SoundType sound, float lightLevel, String tool, int toolLevel, boolean canSustainPlant, CreativeTabs tab) {
        super(materialIn);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf(false)).func_177226_a(VARIANT, (Comparable)((Object)EnumType.ALPHA)));
        this.setRegistryName(nameIn);
        this.func_149663_c(unlocalizedNameIn);
        this.func_149647_a(tab);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.func_149672_a(sound);
        this.func_149715_a(lightLevel);
        if (tool != null) {
            this.setHarvestLevel(tool, toolLevel);
        }
        this.canSustainPlant = canSustainPlant;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return this.canSustainPlant;
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return EnumType.values()[stack.func_77952_i()].name().toLowerCase(Locale.ENGLISH);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        boolean flag = (Boolean)state.func_177229_b((IProperty)ACTIVATED);
        switch (enumfacing) {
            case EAST: {
                return flag ? AABB_EAST_ON : AABB_EAST_OFF;
            }
            case WEST: {
                return flag ? AABB_WEST_ON : AABB_WEST_OFF;
            }
            case SOUTH: {
                return flag ? AABB_SOUTH_ON : AABB_SOUTH_OFF;
            }
        }
        return flag ? AABB_NORTH_ON : AABB_NORTH_OFF;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List list) {
        EnumType[] allType;
        for (EnumType type : allType = EnumType.values()) {
            list.add(new ItemStack(itemIn, 1, type.getMetadata()));
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        boolean flag = worldIn.func_175640_z(pos);
        EnumType enumtype = EnumType.byMetadata(meta);
        EnumFacing enumfacing = placer.func_174811_aO().func_176746_e();
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)enumfacing).func_177226_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf(flag)).func_177226_a(VARIANT, (Comparable)((Object)enumtype));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)ACTIVATED)).booleanValue()) {
            state = state.func_177226_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf(false));
            worldIn.func_180501_a(pos, state, 10);
        } else {
            state = state.func_177226_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf(true));
            worldIn.func_180501_a(pos, state, 10);
        }
        worldIn.func_180498_a(playerIn, (Boolean)state.func_177229_b((IProperty)ACTIVATED) != false ? 1008 : 1014, pos, 0);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)meta);
        int variantbits = (meta & 8) >> 3;
        EnumType variant = EnumType.byMetadata(variantbits);
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)variant)).func_177226_a((IProperty)field_185512_D, (Comparable)facing).func_177226_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        EnumType variant = (EnumType)((Object)state.func_177229_b(VARIANT));
        int facingbits = facing.func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)ACTIVATED)).booleanValue()) {
            facingbits |= 4;
        }
        int variantbits = variant.getMetadata() << 3;
        return facingbits | variantbits;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177230_c() != this ? state : state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVATED, field_185512_D, VARIANT});
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public static enum EnumType implements IStringSerializable
    {
        ALPHA(0, "alpha"),
        BRAVO(1, "bravo");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int metaIn, String nameIn) {
            this.meta = metaIn;
            this.name = nameIn;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta > META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType enumtype;
                EnumType.META_LOOKUP[enumtype.getMetadata()] = enumtype = enumTypeArray[i];
            }
        }
    }
}

