/*
 * Decompiled with CFR 0.152.
 */
package net.creativerealmsmc.conquest.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class LeverBlock
extends Block {
    private boolean canSustainPlant;
    public static final PropertyEnum<EnumOrientation> FACING = PropertyEnum.func_177709_a((String)"facing", EnumOrientation.class);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    protected static final AxisAlignedBB LEVER_NORTH_AABB = new AxisAlignedBB(0.3125, (double)0.2f, 0.625, 0.6875, (double)0.8f, 1.0);
    protected static final AxisAlignedBB LEVER_SOUTH_AABB = new AxisAlignedBB(0.3125, (double)0.2f, 0.0, 0.6875, (double)0.8f, 0.375);
    protected static final AxisAlignedBB LEVER_WEST_AABB = new AxisAlignedBB(0.625, (double)0.2f, 0.3125, 1.0, (double)0.8f, 0.6875);
    protected static final AxisAlignedBB LEVER_EAST_AABB = new AxisAlignedBB(0.0, (double)0.2f, 0.3125, 0.375, (double)0.8f, 0.6875);
    protected static final AxisAlignedBB LEVER_UP_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, (double)0.6f, 0.75);
    protected static final AxisAlignedBB LEVER_DOWN_AABB = new AxisAlignedBB(0.25, (double)0.4f, 0.25, 0.75, 1.0, 0.75);

    public LeverBlock(String nameIn, String unlocalizedNameIn, Material materialIn, float hardness, float resistance, SoundType sound, float lightLevel, String tool, int toolLevel, boolean canSustainPlant, CreativeTabs tab) {
        super(materialIn);
        this.setRegistryName(nameIn);
        this.func_149663_c(unlocalizedNameIn);
        this.func_149647_a(tab);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.func_149672_a(sound);
        this.func_149715_a(lightLevel);
        if (tool != null) {
            this.setHarvestLevel(tool, toolLevel);
        }
        this.canSustainPlant = canSustainPlant;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)((Object)EnumOrientation.NORTH)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return this.canSustainPlant;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return this.canAttachTo(worldIn, pos, side.func_176734_d());
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.canAttachTo(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
        if (this.canAttachTo(worldIn, pos, facing.func_176734_d())) {
            return iblockstate.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.forFacings(facing, placer.func_174811_aO())));
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (enumfacing == facing || !this.canAttachTo(worldIn, pos, enumfacing.func_176734_d())) continue;
            return iblockstate.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.forFacings(enumfacing, placer.func_174811_aO())));
        }
        if (worldIn.func_180495_p(pos.func_177977_b()).func_185896_q()) {
            return iblockstate.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.forFacings(EnumFacing.UP, placer.func_174811_aO())));
        }
        return iblockstate;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (this.checkCanSurvive(worldIn, pos, state) && !this.canAttachTo(worldIn, pos, ((EnumOrientation)((Object)state.func_177229_b(FACING))).getFacing().func_176734_d())) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    private boolean canAttachTo(World worldIn, BlockPos pos, EnumFacing opposite) {
        return true;
    }

    private boolean checkCanSurvive(World p_181091_1_, BlockPos p_181091_2_, IBlockState p_181091_3_) {
        if (this.func_176196_c(p_181091_1_, p_181091_2_)) {
            return true;
        }
        this.func_176226_b(p_181091_1_, p_181091_2_, p_181091_3_, 0);
        p_181091_1_.func_175698_g(p_181091_2_);
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumOrientation)((Object)state.func_177229_b(FACING))) {
            default: {
                return LEVER_EAST_AABB;
            }
            case WEST: {
                return LEVER_WEST_AABB;
            }
            case SOUTH: {
                return LEVER_SOUTH_AABB;
            }
            case NORTH: {
                return LEVER_NORTH_AABB;
            }
            case UP_Z: 
            case UP_X: {
                return LEVER_UP_AABB;
            }
            case DOWN_X: 
            case DOWN_Z: 
        }
        return LEVER_DOWN_AABB;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        state = state.func_177231_a((IProperty)POWERED);
        worldIn.func_180501_a(pos, state, 3);
        float f = (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 0.6f : 0.5f;
        worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, f);
        worldIn.func_175685_c(pos, (Block)this);
        EnumFacing enumfacing = ((EnumOrientation)((Object)state.func_177229_b(FACING))).getFacing();
        worldIn.func_175685_c(pos.func_177972_a(enumfacing.func_176734_d()), (Block)this);
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            worldIn.func_175685_c(pos, (Block)this);
            EnumFacing enumfacing = ((EnumOrientation)((Object)state.func_177229_b(FACING))).getFacing();
            worldIn.func_175685_c(pos.func_177972_a(enumfacing.func_176734_d()), (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) == false ? 0 : (((EnumOrientation)((Object)blockState.func_177229_b(FACING))).getFacing() == side ? 15 : 0);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumOrientation.byMetadata(meta & 7))).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumOrientation)((Object)state.func_177229_b(FACING))).getMetadata();
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                switch ((EnumOrientation)((Object)state.func_177229_b(FACING))) {
                    case EAST: {
                        return state.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.WEST));
                    }
                    case WEST: {
                        return state.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.EAST));
                    }
                    case SOUTH: {
                        return state.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.NORTH));
                    }
                    case NORTH: {
                        return state.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.SOUTH));
                    }
                }
                return state;
            }
            case COUNTERCLOCKWISE_90: {
                switch ((EnumOrientation)((Object)state.func_177229_b(FACING))) {
                    case EAST: {
                        return state.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.NORTH));
                    }
                    case WEST: {
                        return state.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.SOUTH));
                    }
                    case SOUTH: {
                        return state.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.EAST));
                    }
                    case NORTH: {
                        return state.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.WEST));
                    }
                    case UP_Z: {
                        return state.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.UP_X));
                    }
                    case UP_X: {
                        return state.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.UP_Z));
                    }
                    case DOWN_X: {
                        return state.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.DOWN_Z));
                    }
                    case DOWN_Z: {
                        return state.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.DOWN_X));
                    }
                }
            }
            case CLOCKWISE_90: {
                switch ((EnumOrientation)((Object)state.func_177229_b(FACING))) {
                    case EAST: {
                        return state.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.SOUTH));
                    }
                    case WEST: {
                        return state.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.NORTH));
                    }
                    case SOUTH: {
                        return state.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.WEST));
                    }
                    case NORTH: {
                        return state.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.EAST));
                    }
                    case UP_Z: {
                        return state.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.UP_X));
                    }
                    case UP_X: {
                        return state.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.UP_Z));
                    }
                    case DOWN_X: {
                        return state.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.DOWN_Z));
                    }
                    case DOWN_Z: {
                        return state.func_177226_a(FACING, (Comparable)((Object)EnumOrientation.DOWN_X));
                    }
                }
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a(((EnumOrientation)((Object)state.func_177229_b(FACING))).getFacing()));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    private boolean canAttach(World world, BlockPos pos, EnumFacing side) {
        return world.isSideSolid(pos, side);
    }

    public static enum EnumOrientation implements IStringSerializable
    {
        DOWN_X(0, "down_x", EnumFacing.DOWN),
        EAST(1, "east", EnumFacing.EAST),
        WEST(2, "west", EnumFacing.WEST),
        SOUTH(3, "south", EnumFacing.SOUTH),
        NORTH(4, "north", EnumFacing.NORTH),
        UP_Z(5, "up_z", EnumFacing.UP),
        UP_X(6, "up_x", EnumFacing.UP),
        DOWN_Z(7, "down_z", EnumFacing.DOWN);

        private static final EnumOrientation[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final EnumFacing facing;

        private EnumOrientation(int meta, String name, EnumFacing facing) {
            this.meta = meta;
            this.name = name;
            this.facing = facing;
        }

        public int getMetadata() {
            return this.meta;
        }

        public EnumFacing getFacing() {
            return this.facing;
        }

        public String toString() {
            return this.name;
        }

        public static EnumOrientation byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public static EnumOrientation forFacings(EnumFacing clickedSide, EnumFacing entityFacing) {
            switch (clickedSide) {
                case DOWN: {
                    switch (entityFacing.func_176740_k()) {
                        case X: {
                            return DOWN_X;
                        }
                        case Z: {
                            return DOWN_Z;
                        }
                    }
                    throw new IllegalArgumentException("Invalid entityFacing " + entityFacing + " for facing " + clickedSide);
                }
                case UP: {
                    switch (entityFacing.func_176740_k()) {
                        case X: {
                            return UP_X;
                        }
                        case Z: {
                            return UP_Z;
                        }
                    }
                    throw new IllegalArgumentException("Invalid entityFacing " + entityFacing + " for facing " + clickedSide);
                }
                case NORTH: {
                    return NORTH;
                }
                case SOUTH: {
                    return SOUTH;
                }
                case WEST: {
                    return WEST;
                }
                case EAST: {
                    return EAST;
                }
            }
            throw new IllegalArgumentException("Invalid facing: " + clickedSide);
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumOrientation[EnumOrientation.values().length];
            EnumOrientation[] enumOrientationArray = EnumOrientation.values();
            int n = enumOrientationArray.length;
            for (int i = 0; i < n; ++i) {
                EnumOrientation LeverBlock$enumorientation;
                EnumOrientation.META_LOOKUP[LeverBlock$enumorientation.getMetadata()] = LeverBlock$enumorientation = enumOrientationArray[i];
            }
        }
    }
}

