/*
 * Decompiled with CFR 0.152.
 */
package net.creativerealmsmc.conquest.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CauldronBlock
extends Block {
    private boolean canSustainPlant;
    public static final PropertyInteger LEVEL = PropertyInteger.func_177719_a((String)"level", (int)0, (int)3);
    protected static final AxisAlignedBB AABB_LEGS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0);
    protected static final AxisAlignedBB AABB_WALL_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB AABB_WALL_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_EAST = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);

    public CauldronBlock(String nameIn, String unlocalizedNameIn, Material materialIn, float hardness, float resistance, SoundType sound, float lightLevel, String tool, int toolLevel, boolean canSustainPlant, CreativeTabs tab) {
        super(Material.field_151576_e);
        this.setRegistryName(nameIn);
        this.func_149663_c(unlocalizedNameIn);
        this.func_149647_a(tab);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.func_149672_a(sound);
        this.func_149715_a(lightLevel);
        if (tool != null) {
            this.setHarvestLevel(tool, toolLevel);
        }
        this.canSustainPlant = canSustainPlant;
        this.field_149783_u = true;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return this.canSustainPlant;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB p_185477_4_, List<AxisAlignedBB> p_185477_5_, Entity p_185477_6_) {
        CauldronBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)p_185477_4_, p_185477_5_, (AxisAlignedBB)AABB_LEGS);
        CauldronBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)p_185477_4_, p_185477_5_, (AxisAlignedBB)AABB_WALL_WEST);
        CauldronBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)p_185477_4_, p_185477_5_, (AxisAlignedBB)AABB_WALL_NORTH);
        CauldronBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)p_185477_4_, p_185477_5_, (AxisAlignedBB)AABB_WALL_EAST);
        CauldronBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)p_185477_4_, p_185477_5_, (AxisAlignedBB)AABB_WALL_SOUTH);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        int i = (Integer)state.func_177229_b((IProperty)LEVEL);
        float f = (float)pos.func_177956_o() + (6.0f + (float)(3 * i)) / 16.0f;
        if (!worldIn.field_72995_K && entityIn.func_70027_ad() && i > 0 && entityIn.func_174813_aQ().field_72338_b <= (double)f) {
            entityIn.func_70066_B();
            this.setWaterLevel(worldIn, pos, state, i - 1);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemArmor itemarmor;
        if (heldItem == null) {
            return true;
        }
        int i = (Integer)state.func_177229_b((IProperty)LEVEL);
        Item item = heldItem.func_77973_b();
        if (item == Items.field_151131_as) {
            if (i < 3 && !worldIn.field_72995_K) {
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    playerIn.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
                }
                playerIn.func_71029_a(StatList.field_188077_K);
                this.setWaterLevel(worldIn, pos, state, 3);
            }
            return true;
        }
        if (item == Items.field_151133_ar) {
            if (i == 3 && !worldIn.field_72995_K) {
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    --heldItem.field_77994_a;
                    if (heldItem.field_77994_a == 0) {
                        playerIn.func_184611_a(hand, new ItemStack(Items.field_151131_as));
                    } else if (!playerIn.field_71071_by.func_70441_a(new ItemStack(Items.field_151131_as))) {
                        playerIn.func_71019_a(new ItemStack(Items.field_151131_as), false);
                    }
                }
                playerIn.func_71029_a(StatList.field_188078_L);
                this.setWaterLevel(worldIn, pos, state, 0);
            }
            return true;
        }
        if (item == Items.field_151069_bo) {
            if (i > 0 && !worldIn.field_72995_K) {
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    ItemStack itemstack1 = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b);
                    playerIn.func_71029_a(StatList.field_188078_L);
                    if (--heldItem.field_77994_a == 0) {
                        playerIn.func_184611_a(hand, itemstack1);
                    } else if (!playerIn.field_71071_by.func_70441_a(itemstack1)) {
                        playerIn.func_71019_a(itemstack1, false);
                    } else if (playerIn instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)playerIn).func_71120_a(playerIn.field_71069_bz);
                    }
                }
                this.setWaterLevel(worldIn, pos, state, i - 1);
            }
            return true;
        }
        if (i > 0 && item instanceof ItemArmor && (itemarmor = (ItemArmor)item).func_82812_d() == ItemArmor.ArmorMaterial.LEATHER && itemarmor.func_82816_b_(heldItem) && !worldIn.field_72995_K) {
            itemarmor.func_82815_c(heldItem);
            this.setWaterLevel(worldIn, pos, state, i - 1);
            playerIn.func_71029_a(StatList.field_188079_M);
            return true;
        }
        if (i > 0 && item instanceof ItemBanner) {
            if (TileEntityBanner.func_175113_c((ItemStack)heldItem) > 0 && !worldIn.field_72995_K) {
                ItemStack itemstack = heldItem.func_77946_l();
                itemstack.field_77994_a = 1;
                TileEntityBanner.func_175117_e((ItemStack)itemstack);
                playerIn.func_71029_a(StatList.field_188080_N);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    --heldItem.field_77994_a;
                }
                if (heldItem.field_77994_a == 0) {
                    playerIn.func_184611_a(hand, itemstack);
                } else if (!playerIn.field_71071_by.func_70441_a(itemstack)) {
                    playerIn.func_71019_a(itemstack, false);
                } else if (playerIn instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)playerIn).func_71120_a(playerIn.field_71069_bz);
                }
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    this.setWaterLevel(worldIn, pos, state, i - 1);
                }
            }
            return true;
        }
        return false;
    }

    public void setWaterLevel(World worldIn, BlockPos pos, IBlockState state, int level) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)level, (int)0, (int)3))), 2);
        worldIn.func_175666_e(pos, (Block)this);
    }

    public void func_176224_k(World worldIn, BlockPos pos) {
        if (worldIn.field_73012_v.nextInt(20) == 1) {
            IBlockState iblockstate;
            float f = worldIn.func_180494_b(pos).func_180626_a(pos);
            if (worldIn.func_72959_q().func_76939_a(f, pos.func_177956_o()) >= 0.15f && (Integer)(iblockstate = worldIn.func_180495_p(pos)).func_177229_b((IProperty)LEVEL) < 3) {
                worldIn.func_180501_a(pos, iblockstate.func_177231_a((IProperty)LEVEL), 2);
            }
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return (Integer)blockState.func_177229_b((IProperty)LEVEL);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LEVEL);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LEVEL});
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }
}

