/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.util;

import java.io.File;
import me.dags.blockpalette.color.ColorMode;
import me.dags.blockpalette.creative.PickMode;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Config {
    public static boolean show_settings = true;
    public static boolean match_textures = true;
    public static boolean show_tooltips = true;
    public static PickMode pick_mode = PickMode.MOUSE;
    public static boolean hold_key = false;
    public static int highlight_red = 185;
    public static int highlight_green = 185;
    public static int highlight_blue = 185;
    public static float highlight_scale = 1.05f;
    public static ColorMode color_mode = ColorMode.ADJACENT;
    public static float color_opacity = 0.5f;
    public static int group_size = 3;
    public static int angle = 30;
    public static float leniency = 0.25f;
    public static float gray_point = 0.15f;
    public static float alpha_point = 0.5f;
    private static Configuration cfg = new Configuration();

    public static void init(File file) {
        cfg = new Configuration(file);
        cfg.load();
        show_settings = cfg.get("general", "show_settings", false).getBoolean();
        match_textures = cfg.get("general", "match_textures", true).getBoolean();
        show_tooltips = cfg.get("general", "show_tooltips", true).getBoolean();
        pick_mode = PickMode.fromId(cfg.get("general", "pick_mode", 0).getInt());
        hold_key = cfg.get("general", "hold_key", true).getBoolean();
        highlight_red = cfg.get("general", "highlight_red", highlight_red).getInt();
        highlight_green = cfg.get("general", "highlight_green", highlight_green).getInt();
        highlight_blue = cfg.get("general", "highlight_blue", highlight_blue).getInt();
        highlight_scale = (float)cfg.get("general", "highlight_scale", (double)highlight_scale).getDouble();
        color_mode = ColorMode.fromId(cfg.get("color", "color_mode", ColorMode.getId(color_mode)).getInt());
        color_opacity = (float)cfg.get("color", "color_opacity", (double)color_opacity).getDouble();
        angle = cfg.get("color", "angle", angle).getInt();
        group_size = cfg.get("color", "group_size", group_size).getInt();
        leniency = (float)cfg.get("color", "leniency", (double)leniency).getDouble();
        gray_point = (float)cfg.get("color", "gray_point", (double)gray_point).getDouble();
        alpha_point = (float)cfg.get("color", "alpha_point", (double)alpha_point).getDouble();
        cfg.save();
    }

    public static void save() {
        cfg.get("general", "show_settings", show_settings).set(show_settings);
        cfg.get("general", "match_textures", match_textures).set(match_textures);
        cfg.get("general", "show_tooltips", show_tooltips).set(show_tooltips);
        cfg.get("general", "pick_mode", 0).set(PickMode.toId(pick_mode));
        cfg.get("general", "hold_key", true).set(hold_key);
        cfg.get("general", "highlight_red", highlight_red).set(highlight_red);
        cfg.get("general", "highlight_green", highlight_green).set(highlight_green);
        cfg.get("general", "highlight_blue", highlight_blue).set(highlight_blue);
        cfg.get("general", "highlight_scale", (double)highlight_scale).set((double)highlight_scale);
        cfg.get("color", "color_mode", 0).set(ColorMode.getId(color_mode));
        cfg.get("color", "color_opacity", (double)color_opacity).set((double)color_opacity);
        cfg.get("color", "angle", angle).set(angle);
        cfg.get("color", "group_size", group_size).set(group_size);
        cfg.get("color", "leniency", (double)leniency).set((double)leniency);
        cfg.get("color", "gray_point", (double)gray_point).set((double)gray_point);
        cfg.get("color", "alpha_point", (double)alpha_point).set((double)alpha_point);
        cfg.save();
    }
}

