/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.shape;

import java.awt.Point;

public class Edge {
    private final double angle;
    private final double partialAngle;
    private final double length;
    private final double outerLength;
    private final double innerLength;
    final Point start;
    final Point end;
    final Point outerStart;
    final Point outerEnd;
    final Point innerStart;
    final Point innerEnd;

    public Edge(Point cStart, Point oStart, Point iStart, int centerX, int centerY, int radius, int outerPadding, int innerPadding, double angle, double angleIncrement) {
        double rads = Math.toRadians(angle);
        this.start = cStart;
        this.end = Edge.toPoint(centerX, centerY, radius, rads);
        this.outerStart = oStart;
        this.outerEnd = Edge.toPoint(centerX, centerY, radius + outerPadding, rads);
        this.innerStart = iStart;
        this.innerEnd = Edge.toPoint(centerX, centerY, radius - innerPadding, rads);
        this.angle = angle;
        this.partialAngle = angleIncrement;
        this.length = this.start.distance(this.end);
        this.outerLength = this.outerStart.distance(this.outerEnd);
        this.innerLength = this.innerStart.distance(this.innerEnd);
    }

    public double getAngle() {
        return this.angle;
    }

    public Point getPosition(double angle) {
        return Edge.getPosition(this.start, this.end, this.length, angle, this.partialAngle);
    }

    public Point getOuterPosition(double angle) {
        return Edge.getPosition(this.outerStart, this.outerEnd, this.outerLength, angle, this.partialAngle);
    }

    public Point getInnerPosition(double angle) {
        return Edge.getPosition(this.innerStart, this.innerEnd, this.innerLength, angle, this.partialAngle);
    }

    private static Point getPosition(Point start, Point end, double length, double angle, double partialAngle) {
        double progress = angle % partialAngle / partialAngle;
        double dl = progress * length;
        double t = dl / length;
        int x = (int)Math.round((1.0 - t) * start.getX() + t * end.getX());
        int y = (int)Math.round((1.0 - t) * start.getY() + t * end.getY());
        return new Point(x, y);
    }

    static Point toPoint(int cX, int cY, int radius, double rads) {
        int x = (int)Math.round((double)cX + Math.cos(rads) * (double)radius);
        int y = (int)Math.round((double)cY + Math.sin(rads) * (double)radius);
        return new Point(x, y);
    }
}

