/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.search;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import me.dags.blockpalette.color.ColorConst;
import me.dags.blockpalette.color.ColorF;
import me.dags.blockpalette.gui.Hotbar;
import me.dags.blockpalette.palette.PaletteMain;
import me.dags.blockpalette.search.Index;
import me.dags.blockpalette.search.Tag;
import me.dags.blockpalette.util.Value;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SearchScreen
extends GuiScreen {
    private final Value<ItemStack> selected = Value.of(null);
    private final Value<ItemStack> hovered = Value.of(null);
    private final ColorF emptyColor = new ColorF(0.05f, 0.05f, 0.05f);
    private final int width = 200;
    private final int slotSize = 24;
    private final Index<ItemStack> index;
    private final GuiTextField input;
    private final Hotbar hotbar;
    private final PaletteMain main;
    private List<ItemStack> display = Collections.emptyList();
    private int windowWidth = 0;
    private int displayLeft = 0;
    private int displayTop = 0;
    private int hoveredLeft = 0;
    private int hoveredTop = 0;

    public SearchScreen(PaletteMain main) {
        LinkedList stacks = new LinkedList();
        for (Block block : Block.field_149771_c) {
            Item item = Item.func_150898_a((Block)block);
            block.func_149666_a(item, CreativeTabs.field_78027_g, stacks);
        }
        for (Item item : Item.field_150901_e) {
            if (item instanceof ItemBlock) continue;
            item.func_150895_a(item, CreativeTabs.field_78027_g, stacks);
        }
        Index.Builder<ItemStack> builder = Index.builder();
        for (ItemStack stack : stacks) {
            if (stack == null || stack.func_77973_b() == null) continue;
            int id = 31 * stack.func_77973_b().hashCode() + stack.func_77960_j();
            String name = stack.func_82833_r();
            List<Tag> tags = this.getTags(main, stack);
            builder.with(stack, id, name, tags);
        }
        this.main = main;
        this.field_146289_q = Minecraft.func_71410_x().field_71466_p;
        this.hotbar = new Hotbar(this.hovered, this.selected);
        this.index = builder.build();
        this.input = new GuiTextField(0, this.field_146289_q, 0, 0, 200, 20);
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
        this.hotbar.init(width, height);
        this.input.field_146209_f = width / 2 - this.input.field_146218_h / 2;
        this.input.field_146210_g = height / 2 - 4 * this.input.field_146219_i;
        this.windowWidth = width;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.hotbar.draw(mouseX, mouseY, partialTicks);
        this.input.func_146195_b(true);
        this.input.func_146194_f();
        this.drawGrid(mouseX, mouseY);
        this.drawSelected(mouseX, mouseY);
    }

    public void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (this.hotbar.keyTyped(typedChar, keyCode)) {
            return;
        }
        String current = this.input.func_146179_b();
        this.input.func_146201_a(typedChar, keyCode);
        if (!current.equals(this.input.func_146179_b())) {
            this.display = this.index.search(this.input.func_146179_b(), 40);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (this.hotbar.mouseRelease(mouseX, mouseY)) {
            return;
        }
        ItemStack select = this.selected.get();
        ItemStack hover = this.hovered.get();
        if (select != null) {
            this.selected.setNullable(null);
            return;
        }
        if (hover != null) {
            this.selected.setNullable(hover);
        }
    }

    public void func_146281_b() {
        this.hotbar.onClose();
    }

    private void drawGrid(int mouseX, int mouseY) {
        this.hovered.setNullable(null);
        this.displayLeft = this.input.field_146209_f;
        this.displayTop = this.input.field_146210_g + this.input.field_146219_i / 2 + 15;
        int columns = this.input.field_146218_h / 24;
        int padding = (this.input.field_146218_h - 24 * columns) / 2;
        this.drawGridBackground(columns);
        this.drawSlots(mouseX, mouseY, columns, padding);
        this.drawHovered();
        this.drawTooltip(columns);
    }

    private void drawGridBackground(int columns) {
        if (!this.display.isEmpty()) {
            int rows = (int)Math.ceil((double)this.display.size() / (double)columns);
            int height = rows * 24;
            int left = this.displayLeft - 1;
            int top = this.displayTop - 1;
            int right = this.displayLeft + this.input.field_146218_h + 1;
            int bottom = this.displayTop + height + 1;
            Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)-1728053248);
        }
    }

    private void drawSlots(int mouseX, int mouseY, int columns, int padding) {
        int pos = 0;
        RenderHelper.func_74520_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)250.0f);
        GlStateManager.func_179126_j();
        for (ItemStack stack : this.display) {
            int col = pos % columns;
            int row = pos / columns;
            int x = this.displayLeft + padding + 24 * col;
            int y = this.displayTop + 24 * row;
            ColorF color = this.main.getRegistry().getColor(stack, this.emptyColor);
            SearchScreen.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + 24 - 1), (int)(y + 24 - 1), (int)color.toARGB(0.25f));
            Minecraft.func_71410_x().func_175599_af().func_175042_a(stack, x + 4, y + 4);
            if (SearchScreen.contains(mouseX, mouseY, x, y, x + 24, y + 24)) {
                this.hovered.setNullable(stack);
                this.hoveredLeft = x;
                this.hoveredTop = y;
            }
            ++pos;
        }
        GlStateManager.func_179097_i();
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
    }

    private void drawHovered() {
        if (this.hovered.get() != null) {
            int right = this.hoveredLeft + 24;
            int bottom = this.hoveredTop + 24;
            Gui.func_73734_a((int)this.hoveredLeft, (int)this.hoveredTop, (int)(this.hoveredLeft + 1), (int)bottom, (int)-1);
            Gui.func_73734_a((int)this.hoveredLeft, (int)this.hoveredTop, (int)right, (int)(this.hoveredTop + 1), (int)-1);
            Gui.func_73734_a((int)right, (int)this.hoveredTop, (int)(right - 1), (int)bottom, (int)-1);
            Gui.func_73734_a((int)this.hoveredLeft, (int)(bottom - 1), (int)right, (int)bottom, (int)-1);
        }
    }

    private void drawSelected(int mouseX, int mouseY) {
        ItemStack select = this.selected.get();
        if (select != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179126_j();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
            int left = mouseX - 12 + 4;
            int top = mouseY - 12 + 4;
            RenderHelper.func_74520_c();
            Minecraft.func_71410_x().func_175599_af().func_180450_b(select, left, top);
            Minecraft.func_71410_x().func_175599_af().func_175030_a(this.field_146289_q, select, left, top);
            RenderHelper.func_74518_a();
            GlStateManager.func_179097_i();
            GlStateManager.func_179121_F();
        }
    }

    private void drawTooltip(int columns) {
        ItemStack hover = this.hovered.get();
        if (hover != null) {
            String text = hover.func_82833_r();
            int left = this.windowWidth / 2 - this.field_146289_q.func_78256_a(text) / 2;
            int rows = this.display.size() / columns;
            int height = (1 + rows) * 24;
            int top = this.displayTop + height + 10;
            this.field_146289_q.func_175063_a(text, (float)left, (float)top, 0xFFFFFF);
        }
    }

    private List<Tag> getTags(PaletteMain main, ItemStack stack) {
        ColorF color;
        LinkedList<Tag> tags = new LinkedList<Tag>();
        String name = stack.func_82833_r().toLowerCase();
        for (Tag tag : Tag.TAGS) {
            if (!tag.test(name)) continue;
            tags.add(tag);
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block != null) {
            if (block.func_176223_P().func_185898_k() || block.func_176223_P().func_185913_b() || block.func_176223_P().func_185915_l() || block.func_176223_P().func_185914_p()) {
                tags.add(Tag.of("block"));
            }
        } else {
            tags.add(Tag.of("item"));
        }
        if ((color = main.getRegistry().getColor(stack, ColorF.EMPTY)) != ColorF.EMPTY) {
            ColorConst colorConst = ColorConst.nearest(color);
            tags.add(Tag.of(colorConst.name()));
        }
        return tags;
    }

    private static boolean contains(int x, int y, int left, int top, int right, int bottom) {
        return x > left && x < right && y > top && y < bottom;
    }
}

