/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.palette;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.dags.blockpalette.color.ColorF;
import me.dags.blockpalette.color.ColorMode;
import me.dags.blockpalette.creative.PickMode;
import me.dags.blockpalette.gui.Animation;
import me.dags.blockpalette.gui.Hotbar;
import me.dags.blockpalette.gui.Settings;
import me.dags.blockpalette.gui.UI;
import me.dags.blockpalette.palette.PaletteMain;
import me.dags.blockpalette.util.Config;
import me.dags.blockpalette.util.Render;
import me.dags.blockpalette.util.Value;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class PaletteScreen
extends GuiScreen {
    private static final ResourceLocation BUTTON = new ResourceLocation("blockpalette", "textures/gui/button_mask.png");
    private final Settings paletteSettings = new Settings();
    private final Settings colorSettings = new Settings();
    private final Value<Boolean> showSettings = Value.of(Config.show_settings);
    private final Value<Boolean> matchMode = Value.of(Config.match_textures);
    private final Value<PickMode> pickMode = Value.of(Config.pick_mode);
    private final Value<Boolean> holdKey = Value.of(Config.hold_key);
    private final Value<Boolean> tooltips = Value.of(Config.show_tooltips);
    private final Value<Integer> highlightRed = Value.instant(Config.highlight_red);
    private final Value<Integer> highlightGreen = Value.instant(Config.highlight_green);
    private final Value<Integer> highlightBlue = Value.instant(Config.highlight_blue);
    private final Value<Float> highlightScale = Value.instant(Float.valueOf(Config.highlight_scale));
    private final Value<ColorMode> colorMode = Value.of(Config.color_mode);
    private final Value<Float> colorOpacity = Value.instant(Float.valueOf(Config.color_opacity));
    private final Value<Integer> colorAngle = Value.of(Config.angle);
    private final Value<Integer> colorGroupSize = Value.of(Config.group_size);
    private final Value<Float> colorLeniency = Value.of(Float.valueOf(Config.leniency));
    private final Value<Float> grayPoint = Value.of(Float.valueOf(Config.gray_point));
    private final Value<Float> alphaPoint = Value.of(Float.valueOf(Config.alpha_point));
    private final UI.AreaCycler<Boolean> toggleMode = new UI.AreaCycler<Boolean>(this.matchMode, new Boolean[]{true, false}, BUTTON);
    private final UI.AreaCycler<Boolean> toggleSettings = new UI.AreaCycler<Boolean>(this.showSettings, new Boolean[]{true, false}, BUTTON);
    private final List<GuiButton> buttons = new ArrayList<GuiButton>();
    private final Hotbar hotbar;
    private final Runnable refresh = () -> {
        this.main.newPalette(this.main.getPalette().getCenter());
        this.refreshScreen();
    };
    private final PaletteMain main;
    private int width = 0;
    private int height = 0;
    private boolean isCreativeOverlay = false;

    public PaletteScreen(PaletteMain main) {
        this.field_146297_k = Minecraft.func_71410_x();
        this.main = main;
        this.hotbar = new Hotbar(main.getPalette().getStackUnderMouse(), main.getPalette().getSelectedStack());
        this.paletteSettings.add(new UI.Cycler<PickMode>(this.pickMode, PickMode.values(), "palette.control.pickmode"), this.pickMode);
        this.paletteSettings.add(new UI.Cycler<Boolean>(this.holdKey, new Boolean[]{true, false}, "palette.control.hold"), "palette.tooltip.hold");
        this.paletteSettings.add(new UI.Cycler<Boolean>(this.tooltips, new Boolean[]{true, false}, "palette.control.tooltips"), "palette.tooltip.tooltips");
        this.paletteSettings.add(new UI.Label("palette.control.highlight.color.label", ColorF.rgb(255, 255, 255)));
        this.paletteSettings.add((GuiButton)new UI.IntSlider("palette.control.highlight.red", 0.0f, 255.0f, this.highlightRed), "palette.tooltip.highlight.color");
        this.paletteSettings.add((GuiButton)new UI.IntSlider("palette.control.highlight.green", 0.0f, 255.0f, this.highlightGreen), "palette.tooltip.highlight.color");
        this.paletteSettings.add((GuiButton)new UI.IntSlider("palette.control.highlight.blue", 0.0f, 255.0f, this.highlightBlue), "palette.tooltip.highlight.color");
        this.paletteSettings.add(new UI.Label("palette.control.highlight.scale.label", ColorF.rgb(255, 255, 255)));
        this.paletteSettings.add((GuiButton)new UI.FloatSlider("palette.control.highlight.scale", 1.0f, 1.5f, this.highlightScale), "palette.tooltip.highlight.scale");
        this.colorSettings.add(new UI.Label("palette.control.mode.label", 0xFFFFFF));
        this.colorSettings.add(new UI.Cycler<ColorMode>(this.colorMode, ColorMode.values(), "%s"));
        this.colorSettings.add((GuiButton)new UI.FloatSlider("palette.control.opacity", 0.0f, 1.0f, this.colorOpacity));
        this.colorSettings.add(new UI.Label("palette.control.settings.label", 0xFFFFFF));
        this.colorSettings.add((GuiButton)new UI.IntSlider("palette.control.angle", 0.0f, 120.0f, this.colorAngle), "palette.tooltip.angle");
        this.colorSettings.add((GuiButton)new UI.IntSlider("palette.control.groups", 1.0f, 5.0f, this.colorGroupSize), "palette.tooltip.groups");
        this.colorSettings.add((GuiButton)new UI.FloatSlider("palette.control.leniency", 0.0f, 1.0f, this.colorLeniency), "palette.tooltip.leniency");
        this.colorSettings.add((GuiButton)new UI.FloatSlider("palette.control.gray", 0.0f, 1.0f, this.grayPoint), "palette.tooltip.gray");
        this.colorSettings.add((GuiButton)new UI.FloatSlider("palette.control.alpha", 0.0f, 1.0f, this.alphaPoint), "palette.tooltip.alpha");
        this.colorSettings.add(new UI.Label("", 0xFFFFFF));
        this.colorSettings.add(new UI.Button("palette.control.refresh", this.refresh));
        this.buttons.add(this.toggleMode);
        this.buttons.add(this.toggleSettings);
    }

    public void func_73866_w_() {
        this.resize();
        this.init();
        KeyBinding.func_74510_a((int)this.main.show.func_151463_i(), (boolean)true);
    }

    public void func_175273_b(Minecraft minecraft, int w, int h) {
        super.func_175273_b(minecraft, w, h);
        this.resize();
        this.setupAnimations();
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (!this.listeningToKeyRelease() && !this.isCreativeOverlay && this.isMouseBind(mouseButton)) {
            this.field_146297_k.func_71381_h();
            return;
        }
        this.paletteSettings.mousePressed(this.field_146297_k, mouseX, mouseY);
        this.colorSettings.mousePressed(this.field_146297_k, mouseX, mouseY);
        for (GuiButton button : this.buttons) {
            button.func_146116_c(this.field_146297_k, mouseX, mouseY);
        }
    }

    public void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        super.func_146286_b(mouseX, mouseY, mouseButton);
        if (this.isMouseBind(mouseButton) && this.listeningToKeyRelease()) {
            KeyBinding.func_74510_a((int)this.main.show.func_151463_i(), (boolean)false);
            return;
        }
        if (mouseButton == 0 && Keyboard.isKeyDown((int)42) && this.main.getPalette().getStackUnderMouse().isPresent()) {
            this.main.newPalette(this.main.getPalette().getStackUnderMouse().get());
            this.refresh.run();
            return;
        }
        if (this.hotbar.mouseRelease(mouseX, mouseY)) {
            return;
        }
        this.main.getPalette().mouseRelease(mouseX, mouseY, mouseButton);
        this.paletteSettings.mouseReleased(mouseX, mouseY);
        this.colorSettings.mouseReleased(mouseX, mouseY);
        this.main.getPalette().setHighlightColor(this.highlightRed.get(), this.highlightGreen.get(), this.highlightBlue.get());
        this.main.getPalette().setHighlightRadius(this.highlightScale.get().floatValue());
        for (GuiButton button : this.buttons) {
            button.func_146118_a(mouseX, mouseY);
        }
    }

    public void func_73869_a(char key, int code) throws IOException {
        super.func_73869_a(key, code);
        this.hotbar.keyTyped(key, code);
        if (!(this.isCreativeOverlay || code != this.main.show.func_151463_i() || Config.pick_mode != PickMode.MOUSE && Config.hold_key)) {
            this.field_146297_k.func_71381_h();
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.hotbar.onClose();
        this.main.getPalette().close();
        this.main.newPalette(null);
        Config.save();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        KeyBinding.func_186704_a();
        this.paletteSettings.draw(this.field_146297_k, mouseX, mouseY, partialTicks);
        this.colorSettings.draw(this.field_146297_k, mouseX, mouseY, partialTicks);
        this.hotbar.draw(mouseX, mouseY, partialTicks);
        this.main.getPalette().drawScreen(mouseX, mouseY, partialTicks);
        for (GuiButton button : this.buttons) {
            button.func_146112_a(this.field_146297_k, mouseX, mouseY);
        }
        if (Config.show_tooltips) {
            Render.cleanup();
            Render.beginTooltips();
            this.paletteSettings.drawTooltips(mouseX, mouseY, partialTicks);
            this.colorSettings.drawTooltips(mouseX, mouseY, partialTicks);
            Render.endTooltips();
        }
        if (this.listeningToKeyRelease() && this.keybindReleased()) {
            this.field_146297_k.func_71381_h();
        }
    }

    private void addOption(GuiButton button) {
        this.paletteSettings.add(button);
    }

    private void addColor(GuiButton button) {
        this.colorSettings.add(button);
    }

    private boolean listeningToKeyRelease() {
        return !this.isCreativeOverlay && Config.hold_key;
    }

    private boolean keybindReleased() {
        return !this.main.show.func_151470_d();
    }

    private boolean isMouseBind(int code) {
        return code - 100 == this.main.show.func_151463_i();
    }

    public void setCreativeOverlay(boolean overlay) {
        this.isCreativeOverlay = overlay;
    }

    private void refreshScreen() {
        ScaledResolution resolution = new ScaledResolution(this.field_146297_k);
        this.main.getPalette().resize(resolution.func_78326_a(), resolution.func_78328_b());
        this.main.getPalette().setHighlightColor(this.highlightRed.get(), this.highlightGreen.get(), this.highlightBlue.get());
        int centerX = resolution.func_78326_a() / 2;
        int settingsWidth = centerX - this.main.getPalette().getWidth() - 10;
        this.paletteSettings.setSize(settingsWidth, this.height);
        this.colorSettings.setSize(settingsWidth, this.height);
        if (Config.show_settings && !this.paletteSettings.onScreen(this.width, this.height)) {
            this.paletteSettings.open();
        }
        if (!Config.match_textures && !this.colorSettings.onScreen(this.width, this.height)) {
            this.colorSettings.open();
        }
    }

    private void resize() {
        ScaledResolution resolution = new ScaledResolution(this.field_146297_k);
        this.width = resolution.func_78326_a();
        this.height = resolution.func_78328_b();
        this.main.getPalette().resize(resolution.func_78326_a(), resolution.func_78328_b());
        this.hotbar.init(this.width, this.height);
        int centerX = resolution.func_78326_a() / 2;
        int centerY = resolution.func_78328_b() / 2;
        int settingsWidth = centerX - this.main.getPalette().getWidth() - 10;
        this.paletteSettings.setSize(settingsWidth, this.height);
        this.paletteSettings.setPosition(-this.paletteSettings.getWidth(), 0);
        this.colorSettings.setPosition(this.width, 0);
        this.colorSettings.setSize(settingsWidth, this.height);
        this.toggleSettings.field_146128_h = centerX - 80 - 12;
        this.toggleSettings.field_146129_i = centerY - 78 - 12;
        this.toggleSettings.field_146120_f = 24;
        this.toggleSettings.field_146121_g = 24;
        this.toggleMode.field_146128_h = centerX - 30 - 12;
        this.toggleMode.field_146129_i = centerY - 106 - 12;
        this.toggleMode.field_146120_f = 24;
        this.toggleMode.field_146121_g = 24;
        this.setupAnimations();
    }

    private void setupAnimations() {
        int time = 10;
        int paletteStartX = -this.paletteSettings.getWidth();
        int paletteEndX = 0;
        int paletteTop = 0;
        Animation paletteOpen = new Animation(this.paletteSettings, time, paletteStartX, paletteTop, paletteEndX, paletteTop);
        Animation paletteClose = new Animation(this.paletteSettings, time, paletteEndX, paletteTop, paletteStartX, paletteTop);
        this.paletteSettings.setAnimations(paletteOpen, paletteClose);
        int colorStartX = this.width;
        int colorEndX = this.width - this.colorSettings.getWidth();
        int colorTop = 0;
        Animation colorOpen = new Animation(this.colorSettings, time, colorStartX, colorTop, colorEndX, colorTop);
        Animation colorClose = new Animation(this.colorSettings, time, colorEndX, colorTop, colorStartX, colorTop);
        this.colorSettings.setAnimations(colorOpen, colorClose);
    }

    private void init() {
        this.main.getPalette().setHighlightColor(this.highlightRed.get(), this.highlightGreen.get(), this.highlightBlue.get());
        if (Config.show_settings && !this.paletteSettings.onScreen(this.width, this.height)) {
            this.paletteSettings.open();
        }
        if (!Config.match_textures && !this.colorSettings.onScreen(this.width, this.height)) {
            this.colorSettings.open();
        }
        this.showSettings.setListener(value -> {
            Config.show_settings = value;
            if (value.booleanValue() && !this.paletteSettings.onScreen(this.width, this.height)) {
                this.paletteSettings.open();
            } else if (!value.booleanValue() && this.paletteSettings.onScreen(this.width, this.height)) {
                this.paletteSettings.close();
            }
        });
        this.matchMode.setListener(value -> {
            Config.match_textures = value;
            this.refresh.run();
            if (Config.match_textures) {
                if (this.colorSettings.onScreen(this.width, this.height)) {
                    this.colorSettings.close();
                }
            } else {
                this.colorSettings.open();
            }
        });
        this.pickMode.setListener(value -> {
            Config.pick_mode = value;
            if (this.isCreativeOverlay) {
                GuiContainerCreative creative = new GuiContainerCreative((EntityPlayer)this.field_146297_k.field_71439_g);
                this.field_146297_k.func_147108_a((GuiScreen)creative);
            }
        });
        this.holdKey.setListener(value -> {
            Config.hold_key = value;
        });
        this.tooltips.setListener(value -> {
            Config.show_tooltips = value;
        });
        Value.Listener<Integer> colorListener = value -> {
            this.main.getPalette().setHighlightColor(this.highlightRed.get(), this.highlightGreen.get(), this.highlightBlue.get());
            Config.highlight_red = this.highlightRed.get();
            Config.highlight_green = this.highlightGreen.get();
            Config.highlight_blue = this.highlightBlue.get();
        };
        this.highlightRed.setListener(colorListener);
        this.highlightGreen.setListener(colorListener);
        this.highlightBlue.setListener(colorListener);
        this.highlightScale.setListener(value -> {
            this.main.getPalette().setHighlightRadius(this.highlightScale.get().floatValue());
            Config.highlight_scale = value.floatValue();
        });
        this.colorOpacity.setListener(value -> {
            Config.color_opacity = value.floatValue();
        });
        this.colorMode.setListener(value -> {
            Config.color_mode = value;
            this.refresh.run();
        });
        this.colorAngle.setListener(value -> {
            Config.angle = value;
            this.refresh.run();
        });
        this.colorGroupSize.setListener(value -> {
            Config.group_size = value;
            this.refresh.run();
        });
        this.colorLeniency.setListener(value -> {
            Config.leniency = value.floatValue();
            this.refresh.run();
        });
        this.grayPoint.setListener(value -> {
            Config.gray_point = value.floatValue();
            this.refresh.run();
        });
        this.alphaPoint.setListener(value -> {
            Config.alpha_point = value.floatValue();
            this.refresh.run();
        });
    }
}

