/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.palette;

import java.io.File;
import me.dags.blockpalette.palette.Palette;
import me.dags.blockpalette.palette.PaletteRegistry;
import me.dags.blockpalette.palette.PaletteScreen;
import me.dags.blockpalette.search.SearchScreen;
import me.dags.blockpalette.util.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PaletteMain
implements IResourceManagerReloadListener {
    public static final int switchKeyID = 42;
    public final KeyBinding show = new KeyBinding("key.blockpalette.open", 46, "Block Palette");
    public final KeyBinding search = new KeyBinding("key.blockpalette.search", 47, "Block Palette");
    private PaletteRegistry registry = new PaletteRegistry();
    private Palette palette = Palette.EMPTY;
    private volatile boolean reloaded = false;

    public PaletteRegistry getRegistry() {
        if (this.reloaded) {
            this.reloaded = false;
            this.registry = new PaletteRegistry();
            this.getRegistry().buildPalettes();
            this.palette = Palette.EMPTY;
        }
        return this.registry;
    }

    public Palette getPalette() {
        return this.palette;
    }

    public void showPaletteScreen() {
        if (this.palette.isPresent()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new PaletteScreen(this));
        }
    }

    public void newPalette(ItemStack itemStack) {
        this.palette = this.getRegistry().getPalette(itemStack);
    }

    public boolean isInventoryKey(int keyCode) {
        return keyCode == Minecraft.func_71410_x().field_71474_y.field_151445_Q.func_151463_i();
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.reloaded = true;
    }

    public void onPreInit(File config) {
        Config.init(config);
    }

    public void onInit() {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
    }

    public void onTick() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71439_g != null && minecraft.field_71462_r == null && Minecraft.func_71382_s()) {
            if (!this.getPalette().isPresent() && this.show.func_151468_f()) {
                this.newPalette(minecraft.field_71439_g.func_184614_ca());
                this.showPaletteScreen();
                return;
            }
            if (this.search.func_151468_f()) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new SearchScreen(this));
            }
        }
    }
}

