/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.palette;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.dags.blockpalette.color.ColorF;
import me.dags.blockpalette.gui.Slot;
import me.dags.blockpalette.gui.SlotBounds;
import me.dags.blockpalette.palette.PaletteItem;
import me.dags.blockpalette.shape.Polygon;
import me.dags.blockpalette.util.Config;
import me.dags.blockpalette.util.Render;
import me.dags.blockpalette.util.Value;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.CreativeCrafting;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Palette {
    public static final Palette EMPTY = new Palette(new Slot(PaletteItem.EMPTY), Collections.emptyList(), 0.0f);
    private static final ResourceLocation WHEEL = new ResourceLocation("blockpalette", "textures/gui/wheel.png");
    private static final ResourceLocation MASK0 = new ResourceLocation("blockpalette", "textures/gui/wheel_mask0.png");
    private static final ResourceLocation MASK1 = new ResourceLocation("blockpalette", "textures/gui/wheel_mask1.png");
    private static final int EDGES = 6;
    private static final int SCALE_THRESHOLD = 18;
    private static final float CENTER_SCALE = 1.75f;
    private final List<Slot> allSlots = new ArrayList<Slot>();
    private final List<Slot> slots = new ArrayList<Slot>();
    private final int radius = 75;
    private final float scale;
    private final Slot center;
    private int selectedColor = 0xFFFFFF;
    private int highlightColor = 0xFFFFFF;
    private float highlightRadius = 1.1f;
    private int centerX = 0;
    private int centerY = 0;
    private Value<ItemStack> stackUnderMouse = Value.of(null);
    private Value<ItemStack> selectedStack = Value.of(null);

    private Palette(Slot center, List<Slot> slots, float scale) {
        this.center = center;
        this.slots.addAll(slots);
        this.allSlots.add(center);
        this.allSlots.addAll(slots);
        this.scale = scale;
    }

    public boolean isPresent() {
        return this != EMPTY;
    }

    public ItemStack getCenter() {
        return this.center.getStack();
    }

    public Value<ItemStack> getSelectedStack() {
        return this.selectedStack;
    }

    public Value<ItemStack> getStackUnderMouse() {
        return this.stackUnderMouse;
    }

    public int getWidth() {
        return 115;
    }

    public void setHighlightColor(int r, int g, int b) {
        this.highlightColor = ColorF.rgb(r, g, b);
        this.selectedColor = ColorF.rgb(Math.max(0, r - 45), Math.max(0, g - 45), Math.max(0, b - 45));
    }

    public void setHighlightRadius(float highlightRadius) {
        this.highlightRadius = highlightRadius;
    }

    public void drawScreen(int mouseX, int mouseY, float ticks) {
        if (!this.isPresent()) {
            return;
        }
        this.handleMouse(mouseX, mouseY);
        int rad = 119;
        int dim = 238;
        int left = this.centerX - rad;
        int top = this.centerY - rad;
        Render.cleanup();
        Render.drawTexture(WHEEL, left, top, dim, dim, 0.0f, 0.0f, dim, dim);
        if (!Config.match_textures) {
            Render.beginMask(MASK0, left, top, dim, dim, 0.0f, 0.0f, dim, dim);
            for (Slot slot : this.slots) {
                slot.drawBounds();
            }
            Render.endMask();
            Render.beginMask(MASK1, left, top, dim, dim, 0.0f, 0.0f, dim, dim);
            this.center.drawBounds();
            Render.endMask();
        }
        Render.beginItems();
        for (Slot slot : this.allSlots) {
            slot.setHighlight(this.highlightColor, this.selectedColor, this.highlightRadius);
            slot.draw();
        }
        ItemStack selected = this.selectedStack.get();
        ItemStack underMouse = this.stackUnderMouse.get();
        if (selected != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
            Render.drawHighlightedItemStack(selected, mouseX, mouseY, this.highlightRadius, this.selectedColor);
            Render.drawOverlays(selected, mouseX, mouseY);
            GlStateManager.func_179121_F();
        }
        Render.endItems();
        if (underMouse != null) {
            FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
            String text = underMouse.func_82833_r();
            int length = renderer.func_78256_a(text);
            int half = length / 2;
            int cy = this.centerY + rad - 15;
            renderer.func_175063_a(text, (float)(this.centerX - half), (float)cy, 0xFFFFFF);
        }
    }

    public void mouseRelease(int mouseX, int mouseY, int button) {
        Slot hovered = null;
        for (Slot slot : this.allSlots) {
            if (slot.isEmpty() || !slot.mouseOver(mouseX, mouseY)) continue;
            hovered = slot;
            break;
        }
        if (hovered == null) {
            this.getSelectedStack().setNullable(null);
            return;
        }
        if (button == 0) {
            this.getSelectedStack().setNullable(hovered.getStack());
        } else if (button == 1) {
            hovered.setSelected(!hovered.isSelected());
        }
    }

    private void handleMouse(int mouseX, int mouseY) {
        float radsq;
        this.stackUnderMouse.setNullable(null);
        float distance = radsq = 5625.0f;
        Slot hovered = null;
        for (Slot slot : this.allSlots) {
            int dx = mouseX - slot.xPos();
            int dy = mouseY - slot.yPos();
            float dsq = dx * dx + dy * dy;
            float ds = (radsq - dsq) / radsq;
            float scale = this.scale;
            if ((double)ds > 0.5) {
                scale += Math.min(Math.max(ds * ds * 1.05f, 0.0f), 2.0f);
            }
            slot.setHovered(false);
            slot.setScale(slot == this.center ? 1.75f : scale);
            if (slot.isEmpty() || !slot.mouseOver(mouseX, mouseY) || !(dsq < distance)) continue;
            hovered = slot;
            distance = dsq;
        }
        if (hovered != null && !hovered.isEmpty()) {
            hovered.setHovered(true);
            this.stackUnderMouse.setNullable(hovered.getStack());
        }
    }

    public void resize(int width, int height) {
        if (!this.isPresent()) {
            return;
        }
        this.centerX = width / 2;
        this.centerY = height / 2;
        this.center.setPosition(this.centerX, this.centerY);
        this.center.setScale(1.75f);
        Polygon polygon = new Polygon(6, 75, 40, 40);
        polygon.init(this.centerX, this.centerY);
        float spacing = 360.0f / (float)this.slots.size();
        float halfSpacing = spacing / 2.0f;
        for (int i = 0; i < this.slots.size(); ++i) {
            float angle = Palette.clampAngle((float)i * spacing - 90.0f);
            Point position = polygon.getPosition(angle);
            SlotBounds bounds = polygon.getBounds(angle, halfSpacing);
            Slot slot = this.slots.get(i);
            slot.setPosition(position.x, position.y);
            slot.setBounds(bounds);
        }
        this.center.setBounds(Palette.innerBounds(this.centerX, this.centerY));
    }

    public void close() {
        if (!this.isPresent()) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        CreativeCrafting crafting = new CreativeCrafting(Minecraft.func_71410_x());
        player.field_71069_bz.func_75132_a((IContainerListener)crafting);
        if (player.field_71075_bZ.field_75098_d) {
            for (Slot slot : this.allSlots) {
                if (slot.isEmpty() || !slot.isSelected()) continue;
                player.field_71071_by.func_70441_a(slot.getStack());
            }
            player.field_71069_bz.func_75142_b();
        }
        player.field_71069_bz.func_82847_b((IContainerListener)crafting);
    }

    private static float clampAngle(float value) {
        return value < 0.0f ? 360.0f + value : (value > 360.0f ? value - 360.0f : value);
    }

    private static SlotBounds innerBounds(int centerX, int centerY) {
        Polygon polygon = new Polygon(6, 40, 1, 1);
        polygon.init(centerX, centerY);
        return polygon.outline();
    }

    public static Palette texturePalette(PaletteItem centerItem, List<PaletteItem> items) {
        int count = Math.max(18, items.size());
        float scale = 1.15f;
        if (count > 18) {
            float dif = (float)(count - 18) / 18.0f;
            scale -= Math.min(dif, 0.45f);
        }
        ArrayList<Slot> slots = new ArrayList<Slot>();
        Slot center = new Slot(centerItem);
        for (int i = 0; i < count; ++i) {
            PaletteItem stack = i < items.size() ? items.get(i) : PaletteItem.EMPTY;
            Slot slot = new Slot(stack);
            slots.add(slot);
        }
        return new Palette(center, slots, scale);
    }

    public static Palette colorPalette(PaletteItem centerItem, List<PaletteItem> items) {
        int count = items.size();
        float scale = 1.15f;
        if (count > 18) {
            float dif = (float)(count - 18) / 18.0f;
            scale -= Math.min(dif, 0.45f);
        }
        ArrayList<Slot> slots = new ArrayList<Slot>();
        Slot center = new Slot(centerItem);
        for (int i = 0; i < count; ++i) {
            PaletteItem stack = i < items.size() ? items.get(i) : PaletteItem.EMPTY;
            Slot slot = new Slot(stack);
            slots.add(slot);
        }
        return new Palette(center, slots, scale);
    }
}

