/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.gui;

import me.dags.blockpalette.util.Render;
import me.dags.blockpalette.util.Value;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class UI {
    static final Label DUMMY = new Label("", 0xFFFFFF);

    private static GuiSlider.FormatHelper floatFormat() {
        return (id, name, value) -> I18n.func_135052_a((String)"%s: %.2f", (Object[])new Object[]{name, Float.valueOf(value)});
    }

    private static GuiSlider.FormatHelper intFormat() {
        return (id, name, value) -> I18n.func_135052_a((String)"%s: %.0f", (Object[])new Object[]{name, Float.valueOf(value)});
    }

    private static GuiPageButtonList.GuiResponder floatResponder(final Value<Float> pointer) {
        return new GuiPageButtonList.GuiResponder(){

            public void func_175321_a(int id, boolean value) {
            }

            public void func_175320_a(int id, float value) {
                pointer.set(Float.valueOf(value));
            }

            public void func_175319_a(int id, String value) {
            }
        };
    }

    private static GuiPageButtonList.GuiResponder intResponder(final Value<Integer> pointer) {
        return new GuiPageButtonList.GuiResponder(){

            public void func_175321_a(int id, boolean value) {
            }

            public void func_175320_a(int id, float value) {
                pointer.set(Math.round(value));
            }

            public void func_175319_a(int id, String value) {
            }
        };
    }

    public static class IntSlider
    extends GuiSlider {
        private final Value<Integer> value;

        public IntSlider(String name, float min, float max, Value<Integer> value) {
            super(UI.intResponder(value), 0, 0, 0, name, min, max, (float)value.get().intValue(), UI.intFormat());
            this.value = value;
        }

        public void func_146118_a(int mouseX, int mouseY) {
            super.func_146118_a(mouseX, mouseY);
            this.value.markUpdated();
        }
    }

    public static class FloatSlider
    extends GuiSlider {
        private final Value<Float> value;

        public FloatSlider(String name, float min, float max, Value<Float> value) {
            super(UI.floatResponder(value), 0, 0, 0, name, min, max, value.get().floatValue(), UI.floatFormat());
            this.value = value;
        }

        public void func_146118_a(int mouseX, int mouseY) {
            super.func_146118_a(mouseX, mouseY);
            this.value.markUpdated();
        }
    }

    public static class Cycler<T>
    extends GuiButton {
        private final Value<T> value;
        private final String format;
        private final T[] options;
        private int pos = 0;

        public Cycler(Value<T> value, T[] options) {
            this(value, options, "%s");
        }

        public Cycler(Value<T> value, T[] options, String format) {
            super(0, 0, 0, I18n.func_135052_a((String)format, (Object[])new Object[]{value.get()}));
            this.options = options;
            this.format = format;
            this.value = value;
            T defaultValue = value.get();
            for (int i = 0; i < options.length; ++i) {
                T val = options[i];
                if (!val.equals(defaultValue)) continue;
                this.pos = i;
                return;
            }
        }

        public boolean func_146116_c(Minecraft minecraft, int mouseX, int mouseY) {
            boolean pressed = super.func_146116_c(minecraft, mouseX, mouseY);
            if (pressed) {
                super.func_146113_a(minecraft.func_147118_V());
                int n = this.pos = this.pos + 1 < this.options.length ? this.pos + 1 : 0;
                if (this.pos < this.options.length) {
                    this.value.set(this.options[this.pos]);
                    this.field_146126_j = I18n.func_135052_a((String)this.format, (Object[])new Object[]{this.value.get()});
                }
            }
            return pressed;
        }

        public void func_146118_a(int mouseX, int mouseY) {
            super.func_146118_a(mouseX, mouseY);
            this.value.markUpdated();
        }
    }

    public static class Button
    extends GuiButton {
        private final Runnable action;

        public Button(String display, Runnable action) {
            super(0, 0, 0, I18n.func_135052_a((String)display, (Object[])new Object[0]));
            this.action = action;
        }

        public boolean func_146116_c(Minecraft minecraft, int mouseX, int mouseY) {
            boolean pressed = super.func_146116_c(minecraft, mouseX, mouseY);
            if (pressed) {
                super.func_146113_a(minecraft.func_147118_V());
                this.action.run();
            }
            return pressed;
        }
    }

    public static class AreaCycler<T>
    extends Cycler<T> {
        private final ResourceLocation texture;

        public AreaCycler(Value<T> value, T[] options, ResourceLocation texture) {
            super(value, options, "");
            this.texture = texture;
        }

        public void func_146112_a(Minecraft minecraft, int mouseX, int mouseY) {
            boolean bl = this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            if (this.field_146123_n) {
                Render.cleanup();
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                Render.drawTexture(this.texture, this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g, 0.0f, 0.0f, this.field_146120_f, this.field_146121_g);
            }
        }
    }

    public static class Label
    extends GuiButton {
        private final int color;

        public Label(String text, int color) {
            super(0, 0, 0, I18n.func_135052_a((String)text, (Object[])new Object[0]));
            this.color = color;
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            FontRenderer renderer = mc.field_71466_p;
            renderer.func_175063_a(this.field_146126_j, (float)this.field_146128_h, (float)(this.field_146129_i + 10), this.color);
        }
    }
}

