/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.gui;

import java.util.ArrayList;
import java.util.List;
import me.dags.blockpalette.gui.Animation;
import me.dags.blockpalette.gui.Positional;
import me.dags.blockpalette.gui.Tooltip;
import me.dags.blockpalette.util.Value;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Settings
implements Positional {
    private final List<GuiButton> buttons = new ArrayList<GuiButton>();
    private final List<Tooltip> tooltips = new ArrayList<Tooltip>();
    private boolean centreVertically = true;
    private boolean centerHorizontally = true;
    private int buttonMaxWidth = 250;
    private int buttonMinWidth = 100;
    private int buttonHeight = 20;
    private int buttonSeparator = 1;
    private int padding = 20;
    private int left = 0;
    private int top = 0;
    private int width = 0;
    private int height = 0;
    private Animation open;
    private Animation close;
    private Animation animation;

    public int getWidth() {
        return this.width;
    }

    public boolean onScreen(int width, int height) {
        return this.left >= 0 && this.left < width && this.top >= 0 && this.top < height;
    }

    public void setAnimations(Animation open, Animation close) {
        this.open = open;
        this.close = close;
    }

    public void open() {
        this.open.reset();
        this.animation = this.open;
    }

    public void close() {
        this.close.reset();
        this.animation = this.close;
    }

    public void add(GuiButton button) {
        this.buttons.add(button);
    }

    public void add(GuiButton button, String tooltip) {
        this.buttons.add(button);
        this.tooltips.add(Tooltip.of(button, new Tooltip.Simple(tooltip)));
    }

    public void add(GuiButton button, Value<? extends Tooltip.Provider> value) {
        this.buttons.add(button);
        this.tooltips.add(Tooltip.of(button, new Tooltip.PointerTip<Tooltip.Provider>(value)));
    }

    public void setCentreVertically(boolean centreVertically) {
        this.centreVertically = centreVertically;
    }

    @Override
    public void setPosition(int left, int top) {
        this.left = left;
        this.top = top;
    }

    public void setSize(int width, int height) {
        this.width = Math.max(width, this.buttonMinWidth + this.padding + this.padding);
        this.height = height;
    }

    public void mousePressed(Minecraft minecraft, int mouseX, int mouseY) {
        for (GuiButton button : this.buttons) {
            button.func_146116_c(minecraft, mouseX, mouseY);
        }
    }

    public void mouseReleased(int mouseX, int mouseY) {
        for (GuiButton button : this.buttons) {
            button.func_146118_a(mouseX, mouseY);
        }
    }

    public void draw(Minecraft minecraft, int mouseX, int mouseY, float ticks) {
        int pad;
        if (this.animation != null && !this.animation.isComplete()) {
            this.animation.tick();
        }
        int buttonWidth = this.width - this.padding - this.padding;
        int left = this.left + this.padding;
        int top = this.top + this.padding;
        if (buttonWidth > this.buttonMaxWidth) {
            pad = (buttonWidth - this.buttonMaxWidth) / 2;
            buttonWidth = this.buttonMaxWidth;
            if (this.centerHorizontally) {
                left += pad;
            }
        } else if (buttonWidth < this.buttonMinWidth) {
            pad = this.buttonMinWidth - buttonWidth;
            buttonWidth = this.buttonMinWidth - 2;
            pad = pad < 2 * this.padding ? pad / 2 : this.padding;
            left = left - pad + 1;
        }
        if (this.centreVertically) {
            int totalHeight = this.buttons.size() * (this.buttonHeight + this.buttonSeparator);
            int dy = this.height - totalHeight;
            top = dy / 2;
        }
        this.drawBackground();
        for (GuiButton button : this.buttons) {
            button.field_146129_i = top;
            button.field_146128_h = left;
            button.field_146120_f = buttonWidth;
            button.field_146121_g = this.buttonHeight;
            button.func_146112_a(minecraft, mouseX, mouseY);
            top += this.buttonHeight + this.buttonSeparator;
        }
    }

    public void drawTooltips(int mouseX, int mouseY, float ticks) {
        for (Tooltip tooltip : this.tooltips) {
            tooltip.draw(mouseX, mouseY, ticks);
        }
    }

    public void drawBackground() {
        Gui.func_73734_a((int)this.left, (int)this.top, (int)(this.left + this.width), (int)(this.top + this.height), (int)0x20222222);
    }
}

