/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.gui;

import me.dags.blockpalette.util.Value;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.CreativeCrafting;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class Hotbar {
    private final Value<ItemStack> hovered;
    private final Value<ItemStack> selected;
    private final int padding = 4;
    private final int slotSize = 16;
    private int left = 0;
    private int top = 0;
    private int hoveredSlot = -1;

    public Hotbar(Value<ItemStack> hovered, Value<ItemStack> selected) {
        this.hovered = hovered;
        this.selected = selected;
    }

    public void init(int width, int height) {
        int barWidth = 180;
        this.left = width / 2 - barWidth / 2 + 2;
        this.top = height - 16 - 3;
    }

    public void draw(int mouseX, int mouseY, float ticks) {
        this.hoveredSlot = -1;
        for (int i = 0; i < 9; ++i) {
            int left = this.left + i * 20;
            if (!Hotbar.contains(mouseX, mouseY, left, this.top, left + 16, this.top + 16)) continue;
            this.hoveredSlot = i;
            Gui.func_73734_a((int)left, (int)this.top, (int)(left + 16), (int)(this.top + 16), (int)0x22FFFFFF);
        }
    }

    public boolean mouseRelease(int mouseX, int mouseY) {
        int left = this.left - 5;
        int top = this.top - 5;
        int right = this.left + 180;
        int bottom = this.top + 16 + 4 + 5;
        if (Hotbar.contains(mouseX, mouseY, left, top, right, bottom)) {
            if (this.hoveredSlot != -1) {
                if (Keyboard.isKeyDown((int)42)) {
                    this.setSlotStack(this.hoveredSlot, null);
                    return true;
                }
                ItemStack current = this.getSlotStack(this.hoveredSlot);
                ItemStack selected = this.selected.get();
                if (selected != null) {
                    if (current != null && current.func_77969_a(selected)) {
                        ItemStack copy = selected.func_77946_l();
                        int total = copy.field_77994_a + current.field_77994_a;
                        int count = Math.max(total, copy.func_77976_d());
                        int remaining = Math.min(0, current.field_77994_a - count);
                        copy.field_77994_a = count;
                        this.setSlotStack(this.hoveredSlot, copy);
                        if (remaining == 0) {
                            current = null;
                        } else {
                            current.field_77994_a = remaining;
                        }
                    } else {
                        this.setSlotStack(this.hoveredSlot, selected.func_77946_l());
                    }
                } else {
                    this.setSlotStack(this.hoveredSlot, null);
                }
                this.selected.setNullable(current);
            }
            return true;
        }
        return false;
    }

    public boolean keyTyped(char typedChar, int keyCode) {
        int index;
        if (this.hovered.isPresent() && (index = typedChar - 48 - 1) >= 0 && index <= 8) {
            this.setSlotStack(index, this.hovered.get());
            return true;
        }
        return false;
    }

    public void onClose() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        CreativeCrafting crafting = new CreativeCrafting(Minecraft.func_71410_x());
        player.field_71069_bz.func_75132_a((IContainerListener)crafting);
        if (player.field_71075_bZ.field_75098_d) {
            player.field_71069_bz.func_75142_b();
        }
        player.field_71069_bz.func_82847_b((IContainerListener)crafting);
    }

    private ItemStack getSlotStack(int index) {
        return Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70301_a(index);
    }

    private void setSlotStack(int index, ItemStack stack) {
        Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70299_a(index, stack);
    }

    private static boolean contains(int x, int y, int left, int top, int right, int bottom) {
        return x > left && x < right && y > top && y < bottom;
    }
}

