/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.gui;

import me.dags.blockpalette.gui.Positional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Animation {
    private final Positional positional;
    private final int xIncrement;
    private final int yIncrement;
    private final int startX;
    private final int startY;
    private final int endX;
    private final int endY;
    private int xPos;
    private int yPos;
    private long time = 0L;
    private boolean complete = false;

    public Animation(Positional positional, int time, int startX, int startY, int endX, int endY) {
        this.xPos = startX;
        this.yPos = startY;
        this.endX = endX;
        this.endY = endY;
        this.startX = startX;
        this.startY = startY;
        this.positional = positional;
        this.xIncrement = (endX - startX) / time;
        this.yIncrement = (endY - startY) / time;
    }

    public void reset() {
        this.xPos = this.startX;
        this.yPos = this.startY;
        this.complete = false;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void tick() {
        long current;
        if (!this.complete && (current = System.currentTimeMillis()) - this.time > 10L) {
            this.time = current;
            this.xPos = Animation.clamp(this.xPos + this.xIncrement, this.startX, this.endX);
            this.yPos = Animation.clamp(this.yPos + this.yIncrement, this.startY, this.endY);
            this.positional.setPosition(this.xPos, this.yPos);
            this.complete = this.xPos == this.endX && this.yPos == this.endY;
        }
    }

    private static int clamp(int pos, int start, int end) {
        if (end > start) {
            return Math.min(pos, end);
        }
        return Math.max(pos, end);
    }
}

