/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.creative;

import java.io.IOException;
import me.dags.blockpalette.creative.CreativePickMode;
import me.dags.blockpalette.palette.PaletteMain;
import me.dags.blockpalette.palette.PaletteScreen;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MousePickMode
extends CreativePickMode {
    private PaletteScreen screen;
    private boolean showDown = false;
    private boolean lCtrlDown = false;
    private boolean lShiftDown = false;

    public MousePickMode(PaletteMain main) {
        super(main);
        this.screen = new PaletteScreen(main);
        this.screen.func_73866_w_();
        this.main.newPalette(null);
    }

    @Override
    void drawScreen(Event event) {
        if (this.main.getPalette().isPresent()) {
            this.screen.func_73863_a(this.mouseX, this.mouseY, 0.0f);
            event.setCanceled(true);
        }
    }

    @Override
    void pressMouse(Event event, int button) {
        if (this.main.getPalette().isPresent()) {
            try {
                this.screen.func_73864_a(this.mouseX, this.mouseY, button);
                event.setCanceled(true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (this.stackUnderMouse != null && button == 0 && !this.modifierKey()) {
            this.main.newPalette(this.stackUnderMouse);
            this.screen = new PaletteScreen(this.main);
            this.screen.setCreativeOverlay(true);
            this.screen.func_73866_w_();
            event.setCanceled(true);
        } else if (this.isMouseBind(button)) {
            this.showDown = true;
        }
    }

    @Override
    void releaseMouse(Event event, int button) {
        if (this.main.getPalette().isPresent()) {
            event.setCanceled(true);
            if (this.isMouseBind(button)) {
                this.screen.func_146281_b();
                this.main.newPalette(null);
            } else {
                this.screen.func_146286_b(this.mouseX, this.mouseY, button);
            }
        } else if (this.isMouseBind(button)) {
            this.showDown = false;
        }
    }

    @Override
    void pressKey(Event event, char c, int keyCode) {
        if (keyCode == 29) {
            this.lCtrlDown = true;
        } else if (keyCode == 42) {
            this.lShiftDown = true;
        } else if (keyCode == this.main.show.func_151463_i()) {
            this.showDown = true;
        }
        if (this.main.getPalette().isPresent()) {
            event.setCanceled(true);
            try {
                this.screen.func_73869_a(c, keyCode);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    void releaseKey(Event event, char c, int keyCode) {
        if (keyCode == 29) {
            this.lCtrlDown = false;
        } else if (keyCode == 42) {
            this.lShiftDown = false;
        } else if (keyCode == this.main.show.func_151463_i()) {
            this.showDown = false;
        }
        if (this.main.getPalette().isPresent()) {
            if (keyCode == 1 || keyCode == this.main.show.func_151463_i() || this.main.isInventoryKey(keyCode)) {
                this.screen.func_146281_b();
                this.main.newPalette(null);
            }
            event.setCanceled(true);
        }
    }

    private boolean modifierKey() {
        return this.lCtrlDown || this.lShiftDown || this.showDown;
    }

    private boolean isMouseBind(int code) {
        return code - 100 == this.main.show.func_151463_i();
    }
}

