/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.creative;

import me.dags.blockpalette.palette.PaletteMain;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public abstract class CreativePickMode {
    final PaletteMain main;
    ItemStack stackUnderMouse = null;
    int mouseX = 0;
    int mouseY = 0;
    private int width = 0;
    private int height = 0;

    CreativePickMode(PaletteMain main) {
        this.main = main;
    }

    public void onInitGui() {
    }

    public void onDrawScreen(GuiContainerCreative creative, int mouseX, int mouseY, Event event) {
        Slot slot;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        if (this.main.getPalette().isPresent() && (this.width != creative.field_146294_l || this.height != creative.field_146295_m)) {
            this.width = creative.field_146294_l;
            this.height = creative.field_146295_m;
            this.main.getPalette().resize(this.width, this.height);
        }
        this.stackUnderMouse = (slot = creative.getSlotUnderMouse()) != null ? slot.func_75211_c() : null;
        this.drawScreen(event);
    }

    public void onMouseAction(Event event) {
        int button = Mouse.getEventButton();
        if (Mouse.getEventButtonState()) {
            this.pressMouse(event, button);
        } else if (button != -1) {
            this.releaseMouse(event, button);
        }
    }

    public void onKeyAction(Event event) {
        char c = Keyboard.getEventCharacter();
        int key = Keyboard.getEventKey();
        if (Keyboard.getEventKeyState()) {
            this.pressKey(event, c, key);
        } else if (key != -1) {
            this.releaseKey(event, c, key);
        }
    }

    abstract void drawScreen(Event var1);

    abstract void pressMouse(Event var1, int var2);

    abstract void releaseMouse(Event var1, int var2);

    abstract void pressKey(Event var1, char var2, int var3);

    abstract void releaseKey(Event var1, char var2, int var3);
}

