/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.color;

import me.dags.blockpalette.color.ColorF;

public class Texture {
    public static final Texture EMPTY = new Texture();
    public final String name;
    final int hue;
    final float red;
    final float green;
    final float blue;
    final float alpha;
    final float saturation;
    final float brightness;
    final float luminosity;
    final float strength;

    private Texture() {
        this.name = "EMPTY";
        this.hue = -1;
        this.red = 0.0f;
        this.green = 0.0f;
        this.blue = 0.0f;
        this.alpha = 0.0f;
        this.saturation = 0.0f;
        this.brightness = 0.0f;
        this.luminosity = 0.0f;
        this.strength = 0.0f;
    }

    public Texture(String name, int width, int height, int[] data) {
        int size;
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        int colorSize = size = width * height;
        for (int i = 0; i < size; ++i) {
            int c = data[i];
            int alpha = c >> 24 & 0xFF;
            if (alpha == 0) {
                --colorSize;
                continue;
            }
            r += c >> 16 & 0xFF;
            g += c >> 8 & 0xFF;
            b += c & 0xFF;
            a += alpha;
        }
        colorSize = Math.max(colorSize, 1);
        this.red = (float)(r /= colorSize) / 255.0f;
        this.green = (float)(g /= colorSize) / 255.0f;
        this.blue = (float)(b /= colorSize) / 255.0f;
        this.alpha = (float)(a /= size) / 255.0f;
        float[] hsb = Texture.RGBtoHSB(this.red, this.green, this.blue);
        this.name = name;
        this.hue = Math.round(hsb[0]);
        this.saturation = hsb[1];
        this.brightness = hsb[2];
        this.luminosity = 0.2126f * this.red + 0.715f * this.green + 0.0722f * this.blue;
        this.strength = this.brightness * this.saturation;
    }

    public boolean isPresent() {
        return this != EMPTY;
    }

    public ColorF getColor() {
        return new ColorF(this);
    }

    public String toString() {
        return String.format("%s rgba(%s,%s,%s,%s) hue(%s) hsb(%s,%s,%s)", this.name, Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.alpha), this.hue, this.hue, Float.valueOf(this.saturation), Float.valueOf(this.brightness));
    }

    private static float[] RGBtoHSB(float r, float g, float b) {
        float hue;
        float cmin;
        float cmax;
        float[] hsbvals = new float[3];
        float f = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        float f2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = cmax;
        float saturation = cmax != 0.0f ? (cmax - cmin) / cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (cmax - r) / (cmax - cmin);
            float greenc = (cmax - g) / (cmax - cmin);
            float bluec = (cmax - b) / (cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue * 360.0f;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }
}

