/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.color;

import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum ColorMode {
    COMPLIMENTARY("palette.colormode.complimentary"),
    ADJACENT("palette.colormode.adjacent"),
    TRIAD("palette.colormode.triad"),
    TETRAD("palette.colormode.tetrad"),
    RAINBOW("palette.colormode.rainbow");

    public final String display;

    private ColorMode(String in) {
        this.display = in;
    }

    public String toString() {
        return I18n.func_135052_a((String)this.display, (Object[])new Object[0]);
    }

    public static int maxId() {
        return ColorMode.values().length - 1;
    }

    public static int getId(ColorMode mode) {
        switch (mode) {
            case ADJACENT: {
                return 1;
            }
            case TRIAD: {
                return 2;
            }
            case TETRAD: {
                return 3;
            }
            case RAINBOW: {
                return 4;
            }
        }
        return 0;
    }

    public static ColorMode fromId(int id) {
        switch (id) {
            case 1: {
                return ADJACENT;
            }
            case 2: {
                return TRIAD;
            }
            case 3: {
                return TETRAD;
            }
            case 4: {
                return RAINBOW;
            }
        }
        return COMPLIMENTARY;
    }

    public static ColorMode next(ColorMode mode) {
        switch (mode) {
            case ADJACENT: {
                return TRIAD;
            }
            case TRIAD: {
                return TETRAD;
            }
            case TETRAD: {
                return RAINBOW;
            }
        }
        return COMPLIMENTARY;
    }
}

