/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.color;

import java.awt.Color;
import me.dags.blockpalette.color.Texture;

public class ColorF {
    public static final ColorF EMPTY = new ColorF(0.35f, 0.35f, 0.35f);
    public final float red;
    public final float green;
    public final float blue;

    ColorF(Color color) {
        this.red = (float)color.getRed() / 255.0f;
        this.green = (float)color.getGreen() / 255.0f;
        this.blue = (float)color.getBlue() / 255.0f;
    }

    ColorF(Texture texture) {
        this.red = texture.red;
        this.green = texture.green;
        this.blue = texture.blue;
    }

    public ColorF(float r, float g, float b) {
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    private ColorF() {
        this.red = 1.0f;
        this.green = 1.0f;
        this.blue = 1.0f;
    }

    public int toARGB(float opacity) {
        int argb = (int)(opacity * 255.0f);
        argb = (argb << 8) + (int)(this.red * 255.0f);
        argb = (argb << 8) + (int)(this.green * 255.0f);
        argb = (argb << 8) + (int)(this.blue * 255.0f);
        return argb;
    }

    public int colorCode() {
        return ColorF.rgb(Math.round(this.red * 255.0f), Math.round(this.green * 255.0f), Math.round(this.blue * 255.0f));
    }

    public static int rgb(int r, int g, int b) {
        int rgb = r;
        rgb = (rgb << 8) + g;
        rgb = (rgb << 8) + b;
        return rgb;
    }
}

