/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette;

import me.dags.blockpalette.creative.CreativePickMode;
import me.dags.blockpalette.creative.KeybindPickMode;
import me.dags.blockpalette.creative.MousePickMode;
import me.dags.blockpalette.creative.PickMode;
import me.dags.blockpalette.palette.PaletteMain;
import me.dags.blockpalette.util.Config;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GameEvents {
    private final PaletteMain main;
    private CreativePickMode creativeEvents;
    private boolean inCreativeInventory = false;

    public GameEvents(PaletteMain main) {
        this.main = main;
    }

    @SubscribeEvent
    public void onTick(TickEvent.RenderTickEvent event) {
        this.main.onTick();
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Pre event) {
        if (event.getGui() instanceof GuiContainerCreative) {
            this.creativeEvents = Config.pick_mode == PickMode.KEYBOARD ? new KeybindPickMode(this.main) : new MousePickMode(this.main);
            this.creativeEvents.onInitGui();
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (event.getGui() instanceof GuiContainerCreative) {
            GuiContainerCreative inventory = (GuiContainerCreative)event.getGui();
            boolean bl = this.inCreativeInventory = inventory.func_147056_g() != CreativeTabs.field_78027_g.func_78021_a();
            if (this.inCreativeInventory) {
                this.creativeEvents.onDrawScreen(inventory, event.getMouseX(), event.getMouseY(), (Event)event);
            }
        } else if (this.inCreativeInventory) {
            this.inCreativeInventory = false;
        }
    }

    @SubscribeEvent
    public void onMouseInputEvent(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (this.inCreativeInventory) {
            this.creativeEvents.onMouseAction((Event)event);
        }
    }

    @SubscribeEvent
    public void onKeyboarInputEvent(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (this.inCreativeInventory) {
            this.creativeEvents.onKeyAction((Event)event);
        }
    }
}

