/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import team.chisel.Features;
import team.chisel.common.config.Configurations;
import team.chisel.common.init.ChiselBlocks;

@ParametersAreNonnullByDefault
public enum GenerationHandler implements IWorldGenerator
{
    INSTANCE;

    private final List<Pair<WorldGenMinable, WorldGenInfo>> generators = Lists.newArrayList();
    @Nullable
    private static IBlockState basaltstate;
    private static final Predicate<IBlockState> replacecheck;

    public void addGeneration(IBlockState state, WorldGenInfo info) {
        this.addGeneration(new WorldGenMinable(state, info.getAmount(), info.getReplaceable()), info);
    }

    public void addGeneration(WorldGenMinable gen, WorldGenInfo info) {
        this.generators.add((Pair<WorldGenMinable, WorldGenInfo>)Pair.of((Object)gen, (Object)info));
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        for (Pair<WorldGenMinable, WorldGenInfo> p : this.generators) {
            this.generateSurface(world, random, (WorldGenMinable)p.getLeft(), (WorldGenInfo)p.getRight(), chunkX * 16, chunkZ * 16);
        }
    }

    @SubscribeEvent
    public void onLavaLakes(PopulateChunkEvent.Post event) {
        if (Configurations.basaltSpecialGen && Features.BASALT.enabled()) {
            BlockPos origin = new BlockPos(event.getChunkX() * 16 + 8, 0, event.getChunkZ() * 16 + 8);
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)origin, (BlockPos)origin.func_177982_a(15, 11, 15))) {
                IBlockState here = event.getWorld().func_180495_p(pos);
                if (here.func_185904_a() != Material.field_151587_i) continue;
                BlockPos p = pos.func_185334_h();
                World w = event.getWorld();
                int size = Configurations.basaltSideThickness;
                for (BlockPos p2 : BlockPos.func_177975_b((BlockPos)p.func_177967_a(EnumFacing.EAST, size).func_177967_a(EnumFacing.SOUTH, size), (BlockPos)p.func_177967_a(EnumFacing.WEST, size).func_177967_a(EnumFacing.NORTH, size))) {
                    this.replace(w, p2);
                }
                for (int i = 1; i <= Configurations.basaltBottomThickness; ++i) {
                    this.replace(w, p.func_177967_a(EnumFacing.DOWN, i));
                }
            }
        }
    }

    private void replace(World world, BlockPos pos) {
        IBlockState toReplace;
        if (basaltstate == null) {
            basaltstate = ChiselBlocks.basalt2.func_176223_P().func_177226_a((IProperty)ChiselBlocks.basalt2.getMetaProp(), (Comparable)Integer.valueOf(7));
        }
        if ((toReplace = world.func_180495_p(pos)).func_177230_c().isReplaceableOreGen(toReplace, (IBlockAccess)world, pos, replacecheck)) {
            world.func_175656_a(pos, basaltstate);
        }
    }

    private void generateSurface(World world, Random rand, WorldGenMinable gen, WorldGenInfo info, int x, int z) {
        for (int k = 0; k < info.getAmount(); ++k) {
            int firstX = x + rand.nextInt(16);
            int firstY = info.getMinY() + rand.nextInt(info.getMaxY() - info.getMinY()) + 1;
            int firstZ = z + rand.nextInt(16);
            gen.func_180709_b(world, rand, new BlockPos(firstX, firstY, firstZ));
        }
    }

    static {
        replacecheck = BlockMatcher.func_177642_a((Block)Blocks.field_150348_b);
    }

    public static final class WorldGenInfo {
        private final int amount;
        private final int minY;
        private final int maxY;
        private final double chance;
        private final Predicate<IBlockState> replaceable;

        @ConstructorProperties(value={"amount", "minY", "maxY", "chance", "replaceable"})
        public WorldGenInfo(int amount, int minY, int maxY, double chance, Predicate<IBlockState> replaceable) {
            this.amount = amount;
            this.minY = minY;
            this.maxY = maxY;
            this.chance = chance;
            this.replaceable = replaceable;
        }

        public int getAmount() {
            return this.amount;
        }

        public int getMinY() {
            return this.minY;
        }

        public int getMaxY() {
            return this.maxY;
        }

        public double getChance() {
            return this.chance;
        }

        public Predicate<IBlockState> getReplaceable() {
            return this.replaceable;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WorldGenInfo)) {
                return false;
            }
            WorldGenInfo other = (WorldGenInfo)o;
            if (this.getAmount() != other.getAmount()) {
                return false;
            }
            if (this.getMinY() != other.getMinY()) {
                return false;
            }
            if (this.getMaxY() != other.getMaxY()) {
                return false;
            }
            if (Double.compare(this.getChance(), other.getChance()) != 0) {
                return false;
            }
            Predicate<IBlockState> this$replaceable = this.getReplaceable();
            Predicate<IBlockState> other$replaceable = other.getReplaceable();
            return !(this$replaceable == null ? other$replaceable != null : !this$replaceable.equals(other$replaceable));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAmount();
            result = result * 59 + this.getMinY();
            result = result * 59 + this.getMaxY();
            long $chance = Double.doubleToLongBits(this.getChance());
            result = result * 59 + (int)($chance >>> 32 ^ $chance);
            Predicate<IBlockState> $replaceable = this.getReplaceable();
            result = result * 59 + ($replaceable == null ? 43 : $replaceable.hashCode());
            return result;
        }

        public String toString() {
            return "GenerationHandler.WorldGenInfo(amount=" + this.getAmount() + ", minY=" + this.getMinY() + ", maxY=" + this.getMaxY() + ", chance=" + this.getChance() + ", replaceable=" + this.getReplaceable() + ")";
        }
    }
}

