/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.item;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.chisel.Chisel;
import team.chisel.api.IChiselItem;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.ICarvingRegistry;
import team.chisel.api.carving.ICarvingVariation;
import team.chisel.api.carving.IChiselMode;
import team.chisel.client.util.ChiselModeGeometryCache;
import team.chisel.client.util.ClientUtil;
import team.chisel.common.util.NBTUtil;
import team.chisel.common.util.SoundUtil;

@ParametersAreNonnullByDefault
public class ChiselController {
    @SideOnly(value=Side.CLIENT)
    private static ChiselModeGeometryCache cache;

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack held = event.getItemStack();
        if (held.func_77973_b() instanceof IChiselItem) {
            ItemStack target = NBTUtil.getChiselTarget(held);
            IChiselItem chisel = (IChiselItem)held.func_77973_b();
            ICarvingRegistry registry = CarvingUtils.getChiselRegistry();
            IBlockState state = event.getWorld().func_180495_p(event.getPos());
            if (!chisel.canChiselBlock(event.getWorld(), player, event.getHand(), event.getPos(), state)) {
                return;
            }
            ICarvingGroup blockGroup = registry.getGroup(state);
            if (blockGroup == null) {
                return;
            }
            IChiselMode mode = NBTUtil.getChiselMode(held);
            Iterable<? extends BlockPos> candidates = mode.getCandidates(player, event.getPos(), event.getFace());
            if (!target.func_190926_b()) {
                ICarvingGroup sourceGroup = registry.getGroup(target);
                if (blockGroup == sourceGroup) {
                    ICarvingVariation variation = CarvingUtils.getChiselRegistry().getVariation(target);
                    if (variation != null) {
                        if (variation.getBlockState() != null) {
                            ChiselController.setAll(candidates, player, state, variation);
                        }
                    } else {
                        Chisel.logger.warn("Found itemstack {} in group {}, but it has no variation!", new Object[]{target, sourceGroup.getName()});
                    }
                }
            } else {
                ICarvingVariation current = registry.getVariation(state);
                List<ICarvingVariation> variations = blockGroup.getVariations();
                variations = variations.stream().filter(v -> v.getBlockState() != null).collect(Collectors.toList());
                int index = variations.indexOf(current);
                index = player.func_70093_af() ? index - 1 : index + 1;
                index = (index + variations.size()) % variations.size();
                ICarvingVariation next = variations.get(index);
                ChiselController.setAll(candidates, player, state, next);
            }
        }
    }

    private static void setAll(Iterable<? extends BlockPos> candidates, EntityPlayer player, IBlockState origState, ICarvingVariation v) {
        for (BlockPos blockPos : candidates) {
            ChiselController.setVariation(player, blockPos, origState, v);
        }
    }

    private static void setVariation(EntityPlayer player, BlockPos pos, IBlockState origState, ICarvingVariation v) {
        IBlockState targetState = v.getBlockState();
        Preconditions.checkNotNull((Object)targetState, (Object)"Variation state cannot be null!");
        World world = player.field_70170_p;
        IBlockState curState = world.func_180495_p(pos);
        ItemStack held = player.func_184614_ca();
        if (curState == v.getBlockState()) {
            return;
        }
        if (origState != curState) {
            return;
        }
        if (held.func_77973_b() instanceof IChiselItem) {
            world.func_175656_a(pos, targetState);
            boolean breakChisel = false;
            IChiselItem chisel = (IChiselItem)held.func_77973_b();
            ItemStack current = CarvingUtils.getChiselRegistry().getVariation(curState).getStack();
            current.func_190920_e(1);
            ItemStack target = v.getStack();
            target.func_190920_e(1);
            chisel.craftItem(held, current, target, player);
            chisel.onChisel(player.field_70170_p, player, held, v);
            if (held.func_190916_E() <= 0) {
                ItemStack targetStack = NBTUtil.getChiselTarget(held);
                player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)targetStack);
                breakChisel = true;
            }
            if (world.field_72995_K) {
                SoundUtil.playSound(player, held, targetState);
                ClientUtil.addDestroyEffects(world, pos, curState);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onBlockHighlight(DrawBlockHighlightEvent event) {
        ItemStack held = event.getPlayer().func_184614_ca();
        if (held.func_77973_b() instanceof IChiselItem && event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK) {
            EntityPlayer player = event.getPlayer();
            IBlockState state = player.field_70170_p.func_180495_p(event.getTarget().func_178782_a());
            if (state.func_177230_c() == Blocks.field_150350_a) {
                return;
            }
            IChiselMode mode = NBTUtil.getChiselMode(held);
            if (cache == null) {
                cache = new ChiselModeGeometryCache(mode, event.getTarget().func_178782_a(), event.getTarget().field_178784_b);
                Minecraft.func_71410_x().field_71441_e.func_72954_a((IWorldEventListener)cache);
            } else {
                cache.setMode(mode);
                cache.setOrigin(event.getTarget().func_178782_a());
                cache.setSide(event.getTarget().field_178784_b);
            }
            if (cache.size() <= 1) {
                return;
            }
            double px = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
            double py = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
            double pz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
            GlStateManager.func_179147_l();
            GlStateManager.func_179089_o();
            GlStateManager.func_179090_x();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            Tessellator.func_178181_a().func_178180_c().func_178969_c(-px, -py, -pz);
            GlStateManager.func_179136_a((float)-4.0f, (float)-4.0f);
            GlStateManager.func_179088_q();
            GlStateManager.func_179084_k();
            GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            cache.draw();
            GlStateManager.func_179147_l();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            cache.draw();
            GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
            GlStateManager.func_179113_r();
            Tessellator.func_178181_a().func_178180_c().func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179098_w();
            GlStateManager.func_179126_j();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        IChiselItem chisel;
        ItemStack stack;
        if (!event.getWorld().field_72995_K && (stack = event.getItemStack()).func_77973_b() instanceof IChiselItem && (chisel = (IChiselItem)stack.func_77973_b()).canOpenGui(event.getWorld(), event.getEntityPlayer(), event.getHand())) {
            event.getEntityPlayer().openGui((Object)Chisel.instance, 0, event.getWorld(), event.getHand().ordinal(), 0, 0);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack mainhandStack;
        if (event.getHand() == EnumHand.OFF_HAND && (mainhandStack = event.getEntityPlayer().func_184614_ca()).func_77973_b() instanceof IChiselItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLeftClickEntity(AttackEntityEvent event) {
        ItemStack held;
        if (event.getTarget() instanceof EntityPainting && (held = event.getEntityPlayer().func_184614_ca()).func_77973_b() instanceof IChiselItem) {
            EntityPainting painting = (EntityPainting)event.getTarget();
            EntityPainting.EnumArt[] values = EntityPainting.EnumArt.values();
            do {
                painting.field_70522_e = values[(painting.field_70522_e.ordinal() + (event.getEntityPlayer().func_70093_af() ? -1 : 1) + values.length) % values.length];
                painting.func_174859_a(painting.field_174860_b);
            } while (!painting.func_70518_d());
            ChiselController.damageItem(held, event.getEntityPlayer());
            event.getEntityPlayer().field_70170_p.func_184133_a(event.getEntityPlayer(), event.getTarget().func_180425_c(), SoundEvents.field_187694_dK, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            event.setCanceled(true);
        }
    }

    private static void damageItem(ItemStack stack, EntityPlayer player) {
        stack.func_77972_a(1, (EntityLivingBase)player);
        if (stack.func_190916_E() <= 0) {
            player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)stack, (EnumHand)EnumHand.MAIN_HAND);
        }
    }

    private static void updateState(World world, BlockPos pos, ItemStack stack, EntityPlayer player, IBlockState next) {
        IBlockState current = world.func_180495_p(pos);
        if (current != next) {
            world.func_175656_a(pos, next);
            SoundUtil.playSound(player, stack, next);
            if (world.field_72995_K) {
                ClientUtil.addDestroyEffects(world, pos, next);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack stack = event.getPlayer().func_184614_ca();
        if (event.getPlayer().field_71075_bZ.field_75098_d && !stack.func_190926_b() && stack.func_77973_b() instanceof IChiselItem) {
            event.setCanceled(true);
        }
    }
}

