/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.carving;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.oredict.OreDictionary;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.ICarvingRegistry;
import team.chisel.api.carving.ICarvingVariation;
import team.chisel.common.carving.GroupList;
import team.chisel.common.init.ChiselSounds;

@ParametersAreNonnullByDefault
public class Carving
implements ICarvingRegistry {
    GroupList groups = new GroupList();
    private final Multimap<String, ICarvingGroup> oreLookup = HashMultimap.create();
    public static final ICarvingRegistry chisel = new Carving();
    public static final Carving needle = new Carving();

    public static void construct() {
    }

    private Carving() {
    }

    @Override
    @Nullable
    public ICarvingVariation getVariation(IBlockState state) {
        return this.getVariation(state, this.getGroup(state));
    }

    @Override
    @Nullable
    public ICarvingVariation getVariation(ItemStack stack) {
        return this.getVariation(stack, this.getGroup(stack));
    }

    @Nullable
    private ICarvingVariation getVariation(IBlockState state, @Nullable ICarvingGroup group) {
        if (group != null) {
            for (ICarvingVariation v : group.getVariations()) {
                if (v.getBlockState() == null || !v.getBlockState().equals(state)) continue;
                return v;
            }
        }
        return null;
    }

    @Nullable
    private ICarvingVariation getVariation(ItemStack stack, @Nullable ICarvingGroup group) {
        if (group != null) {
            for (ICarvingVariation v : group.getVariations()) {
                if (!stack.func_77969_a(v.getStack()) || v.getStack().func_77978_p() != null && !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)v.getStack())) continue;
                return v;
            }
        }
        return null;
    }

    @Override
    public List<ICarvingVariation> getGroupVariations(IBlockState state) {
        ICarvingGroup group = this.getGroup(state);
        if (group == null) {
            return Collections.emptyList();
        }
        return group.getVariations();
    }

    @Override
    @Deprecated
    @Nullable
    public String getOreName(IBlockState state) {
        return null;
    }

    @Override
    public List<ItemStack> getItemsForChiseling(ItemStack chiseledItem) {
        ICarvingGroup group = null;
        group = this.getGroup(chiseledItem);
        if (group == null) {
            return Collections.emptyList();
        }
        return this.getItemsForChiseling(group);
    }

    @Override
    public List<ItemStack> getItemsForChiseling(ICarvingGroup group) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        List<ICarvingVariation> variations = group.getVariations();
        ArrayList found = Lists.newArrayList();
        if (!group.getVariations().isEmpty()) {
            for (ICarvingVariation v : variations) {
                this.addNewStackToList(v.getStack(), items, found);
            }
        }
        return items;
    }

    private void addNewStackToList(ItemStack stack, List<ItemStack> list, List<ItemStackWrapper> found) {
        ItemStackWrapper wrapper = new ItemStackWrapper(stack);
        if (!found.contains(wrapper)) {
            list.add(stack.func_77946_l());
            found.add(wrapper);
        }
    }

    @Override
    @Nullable
    public ICarvingGroup getGroup(IBlockState state) {
        return this.groups.getGroup(state);
    }

    @Override
    @Nullable
    public ICarvingGroup getGroup(ItemStack stack) {
        ICarvingGroup group = this.groups.getGroup(stack);
        List oreGroups = Arrays.stream(OreDictionary.getOreIDs((ItemStack)stack)).mapToObj(OreDictionary::getOreName).map(arg_0 -> this.oreLookup.get(arg_0)).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
        if (oreGroups.isEmpty() || group != null && ((ICarvingGroup)oreGroups.get(0)).getName().equals(group.getName())) {
            return group;
        }
        if (group == null && oreGroups.size() == 1) {
            return (ICarvingGroup)oreGroups.get(0);
        }
        if (group != null) {
            oreGroups.add(0, group);
        }
        String name = Joiner.on((String)"+").join(oreGroups.stream().map(ICarvingGroup::getName).iterator());
        ICarvingGroup ret = CarvingUtils.getDefaultGroupFor(name);
        for (ICarvingGroup v : oreGroups) {
            v.getVariations().forEach(ret::addVariation);
        }
        return ret;
    }

    @Override
    @Nullable
    public ICarvingGroup getGroup(String name) {
        return this.groups.getGroupByName(name);
    }

    @Override
    @Nullable
    public ICarvingGroup removeGroup(String groupName) {
        ICarvingGroup group = this.groups.getGroupByName(groupName);
        for (Collection oregroups : this.oreLookup.asMap().values()) {
            oregroups.removeIf(g -> g.getName().equals(groupName));
        }
        return this.groups.remove(group) ? group : null;
    }

    @Override
    @Nullable
    public ICarvingVariation removeVariation(IBlockState state) {
        ICarvingGroup group = this.groups.getGroup(state);
        ICarvingVariation ret = null;
        while (group != null) {
            ret = this.removeVariation(state, group.getName());
            group = this.groups.getGroup(state);
        }
        return ret;
    }

    @Override
    @Nullable
    public ICarvingVariation removeVariation(IBlockState state, String group) {
        return this.groups.removeVariation(state, group);
    }

    @Override
    @Nullable
    public ICarvingVariation removeVariation(ItemStack stack) {
        ICarvingGroup group = this.groups.getGroup(stack);
        ICarvingVariation ret = null;
        while (group != null) {
            ret = this.removeVariation(stack, group.getName());
            group = this.groups.getGroup(stack);
        }
        return ret;
    }

    @Override
    @Nullable
    public ICarvingVariation removeVariation(ItemStack stack, String group) {
        return this.groups.removeVariation(stack, group);
    }

    @Override
    @Deprecated
    public void addVariation(String groupName, IBlockState state, int order) {
        ICarvingVariation variation = CarvingUtils.variationFor(state, order);
        this.addVariation(groupName, variation);
    }

    @Override
    public void addVariation(String groupName, ICarvingVariation variation) {
        ICarvingGroup group = this.groups.getGroupByName(groupName);
        if (group == null) {
            group = CarvingUtils.getDefaultGroupFor(groupName);
            this.addGroup(group);
        }
        this.groups.addVariation(groupName, variation);
    }

    @Override
    public void addGroup(ICarvingGroup group) {
        this.groups.add(group);
    }

    @Override
    @Deprecated
    public void registerOre(String name, String oreName) {
    }

    @Override
    public void setVariationSound(String name, SoundEvent sound) {
        ICarvingGroup group = this.groups.getGroupByName(name);
        if (group == null) {
            throw new NullPointerException("Cannot set sound for group " + name + ", as it does not exist.");
        }
        group.setSound(sound);
    }

    @Override
    public SoundEvent getVariationSound(IBlockState state) {
        ICarvingGroup group = this.groups.getGroup(state);
        return this.getSound(group);
    }

    @Override
    public SoundEvent getVariationSound(ItemStack stack) {
        ICarvingGroup group = this.groups.getGroup(stack);
        return this.getSound(group);
    }

    @Override
    public SoundEvent getVariationSound(@Nullable ICarvingVariation variation) {
        ICarvingGroup group = variation == null ? null : this.groups.getGroup(variation);
        return this.getSound(group);
    }

    private SoundEvent getSound(@Nullable ICarvingGroup group) {
        SoundEvent sound = group == null ? null : group.getSound();
        return sound == null ? ChiselSounds.fallback : sound;
    }

    @Override
    public List<String> getSortedGroupNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.groups.getNames());
        Collections.sort(names);
        return names;
    }

    @Override
    public void setOreName(ICarvingGroup group, String ore) {
        this.oreLookup.put((Object)ore, (Object)group);
    }

    static {
        CarvingUtils.chisel = chisel;
    }

    private static class ItemStackWrapper {
        private ItemStack wrapped;

        private ItemStackWrapper(ItemStack stack) {
            this.wrapped = stack;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ItemStackWrapper other = (ItemStackWrapper)obj;
            return ItemStack.func_77989_b((ItemStack)this.wrapped, (ItemStack)other.wrapped) && ItemStack.func_77970_a((ItemStack)this.wrapped, (ItemStack)other.wrapped);
        }
    }
}

