/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.server.component.traits;

import li.cil.oc.Settings$;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.server.component.UpgradeDatabase;
import li.cil.oc.server.component.package$;
import li.cil.oc.server.component.traits.WorldInventoryAnalytics;
import li.cil.oc.server.component.traits.WorldInventoryAnalytics$;
import li.cil.oc.util.DatabaseAccess$;
import li.cil.oc.util.ExtendedArguments$;
import li.cil.oc.util.InventoryUtils$;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Unit$;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public abstract class WorldInventoryAnalytics$class {
    @Callback(doc="function(side:number):number -- Get the number of slots in the inventory on the specified side of the device.")
    public static Object[] getInventorySize(WorldInventoryAnalytics $this, Context context, Arguments args) {
        EnumFacing facing = $this.checkSideForAction(args, 0);
        return WorldInventoryAnalytics$class.withInventory($this, facing, (Function1)new Serializable($this){

            public final Object[] apply(IItemHandler inventory2) {
                return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)inventory2.getSlots())}));
            }
        });
    }

    @Callback(doc="function(side:number, slot:number):number -- Get number of items in the specified slot of the inventory on the specified side of the device.")
    public static Object[] getSlotStackSize(WorldInventoryAnalytics $this, Context context, Arguments args) {
        EnumFacing facing = $this.checkSideForAction(args, 0);
        return WorldInventoryAnalytics$class.withInventory($this, facing, (Function1)new Serializable($this, args){
            private final Arguments args$1;

            public final Object[] apply(IItemHandler inventory2) {
                return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Option$.MODULE$.apply((Object)inventory2.getStackInSlot(ExtendedArguments$.MODULE$.extendedArguments(this.args$1).checkSlot(inventory2, 1))).fold((Function0)new Serializable(this){

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                }, (Function1)new Serializable(this){

                    public final int apply(ItemStack x$1) {
                        return x$1.field_77994_a;
                    }
                })}));
            }
            {
                this.args$1 = args$1;
            }
        });
    }

    @Callback(doc="function(side:number, slot:number):number -- Get the maximum number of items in the specified slot of the inventory on the specified side of the device.")
    public static Object[] getSlotMaxStackSize(WorldInventoryAnalytics $this, Context context, Arguments args) {
        EnumFacing facing = $this.checkSideForAction(args, 0);
        return WorldInventoryAnalytics$class.withInventory($this, facing, (Function1)new Serializable($this, args){
            private final Arguments args$2;

            public final Object[] apply(IItemHandler inventory2) {
                return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Option$.MODULE$.apply((Object)inventory2.getStackInSlot(ExtendedArguments$.MODULE$.extendedArguments(this.args$2).checkSlot(inventory2, 1))).fold((Function0)new Serializable(this){

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                }, (Function1)new Serializable(this){

                    public final int apply(ItemStack x$2) {
                        return x$2.func_77976_d();
                    }
                })}));
            }
            {
                this.args$2 = args$2;
            }
        });
    }

    @Callback(doc="function(side:number, slotA:number, slotB:number[, checkNBT:boolean=false]):boolean -- Get whether the items in the two specified slots of the inventory on the specified side of the device are of the same type.")
    public static Object[] compareStacks(WorldInventoryAnalytics $this, Context context, Arguments args) {
        EnumFacing facing = $this.checkSideForAction(args, 0);
        return WorldInventoryAnalytics$class.withInventory($this, facing, (Function1)new Serializable($this, args){
            private final Arguments args$3;

            public final Object[] apply(IItemHandler inventory2) {
                ItemStack stackA = inventory2.getStackInSlot(ExtendedArguments$.MODULE$.extendedArguments(this.args$3).checkSlot(inventory2, 1));
                ItemStack stackB = inventory2.getStackInSlot(ExtendedArguments$.MODULE$.extendedArguments(this.args$3).checkSlot(inventory2, 2));
                Object[] objectArray = new Object[1];
                ItemStack itemStack = stackA;
                ItemStack itemStack2 = stackB;
                objectArray[0] = BoxesRunTime.boxToBoolean((!(itemStack == null ? itemStack2 != null : !itemStack.equals(itemStack2)) || InventoryUtils$.MODULE$.haveSameItemType(stackA, stackB, this.args$3.optBoolean(3, false)) ? 1 : 0) != 0);
                return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)objectArray));
            }
            {
                this.args$3 = args$3;
            }
        });
    }

    @Callback(doc="function(side:number, slot:number, dbAddress:string, dbSlot:number[, checkNBT:boolean=false]):boolean -- Compare an item in the specified slot in the inventory on the specified side with one in the database with the specified address.")
    public static Object[] compareStackToDatabase(WorldInventoryAnalytics $this, Context context, Arguments args) {
        EnumFacing facing = $this.checkSideForAction(args, 0);
        return WorldInventoryAnalytics$class.withInventory($this, facing, (Function1)new Serializable($this, args){
            private final /* synthetic */ WorldInventoryAnalytics $outer;
            public final Arguments args$4;

            public final Object[] apply(IItemHandler inventory2) {
                int slot = ExtendedArguments$.MODULE$.extendedArguments(this.args$4).checkSlot(inventory2, 1);
                String dbAddress = this.args$4.checkString(2);
                ItemStack stack = inventory2.getStackInSlot(slot);
                return DatabaseAccess$.MODULE$.withDatabase(this.$outer.node(), dbAddress, (Function1<UpgradeDatabase, Object[]>)new Serializable(this, stack){
                    private final /* synthetic */ WorldInventoryAnalytics$.anonfun.compareStackToDatabase.1 $outer;
                    private final ItemStack stack$1;

                    public final Object[] apply(UpgradeDatabase database) {
                        int dbSlot = ExtendedArguments$.MODULE$.extendedArguments(this.$outer.args$4).checkSlot(database.data(), 3);
                        ItemStack dbStack = database.getStackInSlot(dbSlot);
                        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)InventoryUtils$.MODULE$.haveSameItemType(this.stack$1, dbStack, this.$outer.args$4.optBoolean(4, false)))}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.stack$1 = stack$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.args$4 = args$4;
            }
        });
    }

    @Callback(doc="function(side:number, slotA:number, slotB:number):boolean -- Get whether the items in the two specified slots of the inventory on the specified side of the device are equivalent (have shared OreDictionary IDs).")
    public static Object[] areStacksEquivalent(WorldInventoryAnalytics $this, Context context, Arguments args) {
        EnumFacing facing = $this.checkSideForAction(args, 0);
        return WorldInventoryAnalytics$class.withInventory($this, facing, (Function1)new Serializable($this, args){
            private final Arguments args$5;

            public final Object[] apply(IItemHandler inventory2) {
                ItemStack stackA = inventory2.getStackInSlot(ExtendedArguments$.MODULE$.extendedArguments(this.args$5).checkSlot(inventory2, 1));
                ItemStack stackB = inventory2.getStackInSlot(ExtendedArguments$.MODULE$.extendedArguments(this.args$5).checkSlot(inventory2, 2));
                Object[] objectArray = new Object[1];
                ItemStack itemStack = stackA;
                ItemStack itemStack2 = stackB;
                objectArray[0] = BoxesRunTime.boxToBoolean((!(itemStack == null ? itemStack2 != null : !itemStack.equals(itemStack2)) || stackA != null && stackB != null && Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(OreDictionary.getOreIDs((ItemStack)stackA)).intersect((GenSeq)Predef$.MODULE$.wrapIntArray(OreDictionary.getOreIDs((ItemStack)stackB)))).nonEmpty() ? 1 : 0) != 0);
                return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)objectArray));
            }
            {
                this.args$5 = args$5;
            }
        });
    }

    @Callback(doc="function(side:number, slot:number):table -- Get a description of the stack in the inventory on the specified side of the device.")
    public static Object[] getStackInSlot(WorldInventoryAnalytics $this, Context context, Arguments args) {
        Object[] objectArray;
        if (Settings$.MODULE$.get().allowItemStackInspection()) {
            EnumFacing facing = $this.checkSideForAction(args, 0);
            objectArray = WorldInventoryAnalytics$class.withInventory($this, facing, (Function1)new Serializable($this, args){
                private final Arguments args$6;

                public final Object[] apply(IItemHandler inventory2) {
                    return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inventory2.getStackInSlot(ExtendedArguments$.MODULE$.extendedArguments(this.args$6).checkSlot(inventory2, 1))}));
                }
                {
                    this.args$6 = args$6;
                }
            });
        } else {
            objectArray = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "not enabled in config"}));
        }
        return objectArray;
    }

    @Callback(doc="function(side:number, slot:number, dbAddress:string, dbSlot:number):boolean -- Store an item stack description in the specified slot of the database with the specified address.")
    public static Object[] store(WorldInventoryAnalytics $this, Context context, Arguments args) {
        EnumFacing facing = $this.checkSideForAction(args, 0);
        String dbAddress = args.checkString(2);
        return WorldInventoryAnalytics$class.withInventory($this, facing, (Function1)new Serializable($this, dbAddress, args){
            private final /* synthetic */ WorldInventoryAnalytics $outer;
            private final String dbAddress$1;
            private final Arguments args$7;

            public final Object[] apply(IItemHandler inventory2) {
                return WorldInventoryAnalytics$class.store$1(this.$outer, inventory2.getStackInSlot(ExtendedArguments$.MODULE$.extendedArguments(this.args$7).checkSlot(inventory2, 1)), this.dbAddress$1, this.args$7);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dbAddress$1 = dbAddress$1;
                this.args$7 = args$7;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object[] withInventory(WorldInventoryAnalytics $this, EnumFacing side, Function1 f) {
        Option<IItemHandler> option = InventoryUtils$.MODULE$.inventoryAt($this.position().offset(side), side.func_176734_d());
        if (!(option instanceof Some)) return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "no inventory"}));
        Some some = (Some)option;
        IItemHandler inventory2 = (IItemHandler)some.x();
        if (!$this.mayInteract($this.position().offset(side), side.func_176734_d(), inventory2)) return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "no inventory"}));
        return (Object[])f.apply((Object)inventory2);
    }

    public static final Object[] store$1(WorldInventoryAnalytics $this, ItemStack stack, String dbAddress$1, Arguments args$7) {
        return DatabaseAccess$.MODULE$.withDatabase($this.node(), dbAddress$1, (Function1<UpgradeDatabase, Object[]>)new Serializable($this, stack, args$7){
            private final ItemStack stack$2;
            private final Arguments args$7;

            public final Object[] apply(UpgradeDatabase database) {
                int dbSlot = ExtendedArguments$.MODULE$.extendedArguments(this.args$7).checkSlot(database.data(), 3);
                boolean nonEmpty = database.getStackInSlot(dbSlot) != null;
                database.setStackInSlot(dbSlot, this.stack$2.func_77946_l());
                return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)nonEmpty)}));
            }
            {
                this.stack$2 = stack$2;
                this.args$7 = args$7;
            }
        });
    }

    public static void $init$(WorldInventoryAnalytics $this) {
    }
}

