/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowlib.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import net.shadowfacts.shadowlib.util.IOUtils;

public class InternetUtils {
    public static String getResourceAsString(String url) throws IOException {
        return InternetUtils.getResourceAsString(new URL(url));
    }

    public static String getResourceAsString(URL url) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            String string = IOUtils.copyToString(reader);
            return string;
        }
    }

    public static void downloadFile(String url, File destination) throws IOException {
        InternetUtils.downloadFile(new URL(url), destination);
    }

    public static void downloadFile(String url, String destination) throws IOException {
        InternetUtils.downloadFile(new URL(url), new File(destination));
    }

    public static void downloadFile(URL url, String destination) throws IOException {
        InternetUtils.downloadFile(url, new File(destination));
    }

    public static void downloadFile(URL url, File destination) throws IOException {
        ReadableByteChannel in = Channels.newChannel(url.openStream());
        File parent = destination.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        FileChannel out = new FileOutputStream(destination).getChannel();
        out.transferFrom(in, 0L, Long.MAX_VALUE);
    }
}

