/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.okhttp3.internal.connection;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.Socket;
import net.shadowfacts.discordchat.repack.okhttp3.Address;
import net.shadowfacts.discordchat.repack.okhttp3.ConnectionPool;
import net.shadowfacts.discordchat.repack.okhttp3.OkHttpClient;
import net.shadowfacts.discordchat.repack.okhttp3.Route;
import net.shadowfacts.discordchat.repack.okhttp3.internal.Internal;
import net.shadowfacts.discordchat.repack.okhttp3.internal.Util;
import net.shadowfacts.discordchat.repack.okhttp3.internal.connection.RealConnection;
import net.shadowfacts.discordchat.repack.okhttp3.internal.connection.RouteDatabase;
import net.shadowfacts.discordchat.repack.okhttp3.internal.connection.RouteException;
import net.shadowfacts.discordchat.repack.okhttp3.internal.connection.RouteSelector;
import net.shadowfacts.discordchat.repack.okhttp3.internal.http.HttpCodec;
import net.shadowfacts.discordchat.repack.okhttp3.internal.http2.ConnectionShutdownException;
import net.shadowfacts.discordchat.repack.okhttp3.internal.http2.ErrorCode;
import net.shadowfacts.discordchat.repack.okhttp3.internal.http2.StreamResetException;

public final class StreamAllocation {
    public final Address address;
    private Route route;
    private final ConnectionPool connectionPool;
    private final Object callStackTrace;
    private final RouteSelector routeSelector;
    private int refusedStreamCount;
    private RealConnection connection;
    private boolean released;
    private boolean canceled;
    private HttpCodec codec;

    public StreamAllocation(ConnectionPool connectionPool, Address address, Object callStackTrace) {
        this.connectionPool = connectionPool;
        this.address = address;
        this.routeSelector = new RouteSelector(address, this.routeDatabase());
        this.callStackTrace = callStackTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpCodec newStream(OkHttpClient client, boolean doExtensiveHealthChecks) {
        int connectTimeout = client.connectTimeoutMillis();
        int readTimeout = client.readTimeoutMillis();
        int writeTimeout = client.writeTimeoutMillis();
        boolean connectionRetryEnabled = client.retryOnConnectionFailure();
        try {
            RealConnection resultConnection = this.findHealthyConnection(connectTimeout, readTimeout, writeTimeout, connectionRetryEnabled, doExtensiveHealthChecks);
            HttpCodec resultCodec = resultConnection.newCodec(client, this);
            ConnectionPool connectionPool = this.connectionPool;
            synchronized (connectionPool) {
                this.codec = resultCodec;
                return resultCodec;
            }
        }
        catch (IOException e) {
            throw new RouteException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealConnection findHealthyConnection(int connectTimeout, int readTimeout, int writeTimeout, boolean connectionRetryEnabled, boolean doExtensiveHealthChecks) throws IOException {
        RealConnection candidate;
        while (true) {
            candidate = this.findConnection(connectTimeout, readTimeout, writeTimeout, connectionRetryEnabled);
            ConnectionPool connectionPool = this.connectionPool;
            synchronized (connectionPool) {
                if (candidate.successCount == 0) {
                    return candidate;
                }
            }
            if (candidate.isHealthy(doExtensiveHealthChecks)) break;
            this.noNewStreams();
        }
        return candidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealConnection findConnection(int connectTimeout, int readTimeout, int writeTimeout, boolean connectionRetryEnabled) throws IOException {
        RealConnection result;
        Route selectedRoute;
        Object allocatedConnection;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (this.released) {
                throw new IllegalStateException("released");
            }
            if (this.codec != null) {
                throw new IllegalStateException("codec != null");
            }
            if (this.canceled) {
                throw new IOException("Canceled");
            }
            allocatedConnection = this.connection;
            if (allocatedConnection != null && !((RealConnection)allocatedConnection).noNewStreams) {
                return allocatedConnection;
            }
            Internal.instance.get(this.connectionPool, this.address, this, null);
            if (this.connection != null) {
                return this.connection;
            }
            selectedRoute = this.route;
        }
        if (selectedRoute == null) {
            selectedRoute = this.routeSelector.next();
        }
        allocatedConnection = this.connectionPool;
        synchronized (allocatedConnection) {
            if (this.canceled) {
                throw new IOException("Canceled");
            }
            Internal.instance.get(this.connectionPool, this.address, this, selectedRoute);
            if (this.connection != null) {
                this.route = selectedRoute;
                return this.connection;
            }
            this.route = selectedRoute;
            this.refusedStreamCount = 0;
            result = new RealConnection(this.connectionPool, selectedRoute);
            this.acquire(result);
        }
        result.connect(connectTimeout, readTimeout, writeTimeout, connectionRetryEnabled);
        this.routeDatabase().connected(result.route());
        Socket socket = null;
        ConnectionPool connectionPool2 = this.connectionPool;
        synchronized (connectionPool2) {
            Internal.instance.put(this.connectionPool, result);
            if (result.isMultiplexed()) {
                socket = Internal.instance.deduplicate(this.connectionPool, this.address, this);
                result = this.connection;
            }
        }
        Util.closeQuietly(socket);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamFinished(boolean noNewStreams, HttpCodec codec) {
        Socket socket;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (codec == null || codec != this.codec) {
                throw new IllegalStateException("expected " + this.codec + " but was " + codec);
            }
            if (!noNewStreams) {
                ++this.connection.successCount;
            }
            socket = this.deallocate(noNewStreams, false, true);
        }
        Util.closeQuietly(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpCodec codec() {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            return this.codec;
        }
    }

    private RouteDatabase routeDatabase() {
        return Internal.instance.routeDatabase(this.connectionPool);
    }

    public synchronized RealConnection connection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Socket socket;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            socket = this.deallocate(false, true, false);
        }
        Util.closeQuietly(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noNewStreams() {
        Socket socket;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            socket = this.deallocate(true, false, false);
        }
        Util.closeQuietly(socket);
    }

    private Socket deallocate(boolean noNewStreams, boolean released, boolean streamFinished) {
        assert (Thread.holdsLock(this.connectionPool));
        if (streamFinished) {
            this.codec = null;
        }
        if (released) {
            this.released = true;
        }
        Socket socket = null;
        if (this.connection != null) {
            if (noNewStreams) {
                this.connection.noNewStreams = true;
            }
            if (this.codec == null && (this.released || this.connection.noNewStreams)) {
                this.release(this.connection);
                if (this.connection.allocations.isEmpty()) {
                    this.connection.idleAtNanos = System.nanoTime();
                    if (Internal.instance.connectionBecameIdle(this.connectionPool, this.connection)) {
                        socket = this.connection.socket();
                    }
                }
                this.connection = null;
            }
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        RealConnection connectionToCancel;
        HttpCodec codecToCancel;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            this.canceled = true;
            codecToCancel = this.codec;
            connectionToCancel = this.connection;
        }
        if (codecToCancel != null) {
            codecToCancel.cancel();
        } else if (connectionToCancel != null) {
            connectionToCancel.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamFailed(IOException e) {
        Socket socket;
        boolean noNewStreams = false;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (e instanceof StreamResetException) {
                StreamResetException streamResetException = (StreamResetException)e;
                if (streamResetException.errorCode == ErrorCode.REFUSED_STREAM) {
                    ++this.refusedStreamCount;
                }
                if (streamResetException.errorCode != ErrorCode.REFUSED_STREAM || this.refusedStreamCount > 1) {
                    noNewStreams = true;
                    this.route = null;
                }
            } else if (this.connection != null && (!this.connection.isMultiplexed() || e instanceof ConnectionShutdownException)) {
                noNewStreams = true;
                if (this.connection.successCount == 0) {
                    if (this.route != null && e != null) {
                        this.routeSelector.connectFailed(this.route, e);
                    }
                    this.route = null;
                }
            }
            socket = this.deallocate(noNewStreams, false, true);
        }
        Util.closeQuietly(socket);
    }

    public void acquire(RealConnection connection) {
        assert (Thread.holdsLock(this.connectionPool));
        if (this.connection != null) {
            throw new IllegalStateException();
        }
        this.connection = connection;
        connection.allocations.add(new StreamAllocationReference(this, this.callStackTrace));
    }

    private void release(RealConnection connection) {
        int size = connection.allocations.size();
        for (int i = 0; i < size; ++i) {
            Reference<StreamAllocation> reference = connection.allocations.get(i);
            if (reference.get() != this) continue;
            connection.allocations.remove(i);
            return;
        }
        throw new IllegalStateException();
    }

    public Socket releaseAndAcquire(RealConnection newConnection) {
        assert (Thread.holdsLock(this.connectionPool));
        if (this.codec != null || this.connection.allocations.size() != 1) {
            throw new IllegalStateException();
        }
        Reference<StreamAllocation> onlyAllocation = this.connection.allocations.get(0);
        Socket socket = this.deallocate(true, false, false);
        this.connection = newConnection;
        newConnection.allocations.add(onlyAllocation);
        return socket;
    }

    public boolean hasMoreRoutes() {
        return this.route != null || this.routeSelector.hasNext();
    }

    public String toString() {
        RealConnection connection = this.connection();
        return connection != null ? connection.toString() : this.address.toString();
    }

    public static final class StreamAllocationReference
    extends WeakReference<StreamAllocation> {
        public final Object callStackTrace;

        StreamAllocationReference(StreamAllocation referent, Object callStackTrace) {
            super(referent);
            this.callStackTrace = callStackTrace;
        }
    }
}

