/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.one_twelve_two;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.shadowfacts.discordchat.api.IConfig;
import net.shadowfacts.discordchat.api.IDiscordChat;
import net.shadowfacts.discordchat.api.ILogger;
import net.shadowfacts.discordchat.api.permission.IPermissionManager;
import net.shadowfacts.discordchat.api.permission.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Role;

public class CommandDC
extends CommandBase {
    private IDiscordChat discordChat;
    private ILogger logger;
    private IConfig config;
    private IPermissionManager permissionManager;
    private Map<String, BiConsumer<ICommandSender, String[]>> subcommands = new HashMap<String, BiConsumer<ICommandSender, String[]>>();

    public CommandDC(IDiscordChat discordChat) {
        this.discordChat = discordChat;
        this.logger = discordChat.getLogger();
        this.config = discordChat.getConfig();
        this.permissionManager = discordChat.getPermissionManager();
        this.subcommands.put("setpermission", this::setPermission);
        this.subcommands.put("tell", this::tell);
    }

    public String func_71517_b() {
        return "discordchat";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/discordchat <setpermission|tell>";
    }

    public List<String> func_71514_a() {
        return ImmutableList.of((Object)"dc");
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        String command = args[0].toLowerCase();
        args = Arrays.copyOfRange(args, 1, args.length);
        if (!this.subcommands.containsKey(command)) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        this.subcommands.get(command).accept(sender, args);
    }

    private void setPermission(ICommandSender sender, String[] args) {
        if (args.length < 2) {
            this.wrongUsage(sender, "/discordchat setPermission <discord role name> <permission>");
        }
        Permission permission = Permission.valueOf(args[args.length - 1].toUpperCase());
        String role = String.join((CharSequence)" ", Arrays.copyOfRange(args, 0, args.length - 1));
        List<Role> roles = this.discordChat.getJDA().getGuildById(this.config.getServerID()).getRolesByName(role, true);
        if (roles.isEmpty()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("No such role: " + role));
            return;
        }
        this.permissionManager.set(roles.get(0), permission);
        try {
            this.permissionManager.save();
            sender.func_145747_a((ITextComponent)new TextComponentString("Permissions updated"));
        }
        catch (IOException e) {
            this.logger.error(e, "Unable to save permissions", new Object[0]);
        }
    }

    private void tell(ICommandSender sender, String[] args) {
        if (args.length < 2) {
            this.wrongUsage(sender, "/discordchat tell <user> <message>");
        } else {
            String user = args[0];
            String message = "";
            for (int i = 1; i < args.length; ++i) {
                message = message + args[i];
                if (i == args.length - 1) continue;
                message = message + " ";
            }
            this.discordChat.sendPrivateMessage(sender.func_70005_c_(), message, user);
        }
    }

    private void wrongUsage(ICommandSender sender, String usage) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.generic.usage", new Object[]{usage}));
    }
}

