/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.restaction.pagination;

import java.util.ArrayList;
import java.util.List;
import net.shadowfacts.discordchat.gnu.trove.map.hash.TLongObjectHashMap;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.audit.ActionType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.audit.AuditLogEntry;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.EntityBuilder;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Response;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.restaction.pagination.PaginationAction;
import net.shadowfacts.discordchat.repack.org.json.JSONArray;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class AuditLogPaginationAction
extends PaginationAction<AuditLogEntry, AuditLogPaginationAction> {
    protected final Guild guild;
    protected ActionType type = null;
    protected String userId = null;

    public AuditLogPaginationAction(Guild guild) {
        super(guild.getJDA(), Route.Guilds.GET_AUDIT_LOGS.compile(guild.getId()), 1, 100, 100);
        if (!guild.getSelfMember().hasPermission(Permission.VIEW_AUDIT_LOGS)) {
            throw new InsufficientPermissionException(Permission.VIEW_AUDIT_LOGS);
        }
        this.guild = guild;
    }

    public AuditLogPaginationAction type(ActionType type) {
        this.type = type;
        return this;
    }

    public AuditLogPaginationAction user(User user) {
        return this.user(user == null ? null : user.getId());
    }

    public AuditLogPaginationAction user(String userId) {
        this.userId = userId;
        return this;
    }

    public AuditLogPaginationAction user(long userId) {
        return this.user(Long.toUnsignedString(userId));
    }

    public Guild getGuild() {
        return this.guild;
    }

    @Override
    protected Route.CompiledRoute finalizeRoute() {
        Route.CompiledRoute route = super.finalizeRoute();
        String limit = String.valueOf(this.limit.get());
        AuditLogEntry last = (AuditLogEntry)this.last;
        route = route.withQueryParams("limit", limit);
        if (this.type != null) {
            route = route.withQueryParams("action_type", String.valueOf(this.type.getKey()));
        }
        if (this.userId != null) {
            route = route.withQueryParams("action_type", this.userId);
        }
        if (last != null) {
            route = route.withQueryParams("before", last.getId());
        }
        return route;
    }

    @Override
    protected void handleResponse(Response response, Request<List<AuditLogEntry>> request) {
        int i;
        if (!response.isOk()) {
            request.onFailure(response);
            return;
        }
        JSONObject obj = response.getObject();
        JSONArray users = obj.getJSONArray("users");
        JSONArray entries = obj.getJSONArray("audit_log_entries");
        ArrayList<AuditLogEntry> list = new ArrayList<AuditLogEntry>(entries.length());
        EntityBuilder builder = this.api.getEntityBuilder();
        TLongObjectHashMap<JSONObject> userMap = new TLongObjectHashMap<JSONObject>();
        for (i = 0; i < users.length(); ++i) {
            JSONObject user = users.getJSONObject(i);
            userMap.put(user.getLong("id"), user);
        }
        for (i = 0; i < entries.length(); ++i) {
            JSONObject entry = entries.getJSONObject(i);
            JSONObject user = (JSONObject)userMap.get(entry.getLong("user_id"));
            AuditLogEntry result = builder.createAuditLogEntry((GuildImpl)this.guild, entry, user);
            list.add(result);
            if (this.useCache) {
                this.cached.add(result);
            }
            this.last = result;
        }
        request.onSuccess(list);
    }
}

