/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers;

import java.awt.Color;
import javax.annotation.CheckReturnValue;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Role;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.HierarchyException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.fields.PermissionField;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.fields.RoleField;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Response;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.Checks;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class RoleManagerUpdatable {
    protected final Role role;
    protected RoleField<String> name;
    protected RoleField<Color> color;
    protected RoleField<Boolean> hoisted;
    protected RoleField<Boolean> mentionable;
    protected PermissionField permissions;

    public RoleManagerUpdatable(Role role) {
        this.role = role;
        this.setupFields();
    }

    public JDA getJDA() {
        return this.role.getJDA();
    }

    public Guild getGuild() {
        return this.role.getGuild();
    }

    public Role getRole() {
        return this.role;
    }

    public RoleField<String> getNameField() {
        return this.name;
    }

    public RoleField<Color> getColorField() {
        return this.color;
    }

    public RoleField<Boolean> getHoistedField() {
        return this.hoisted;
    }

    public RoleField<Boolean> getMentionableField() {
        return this.mentionable;
    }

    public PermissionField getPermissionField() {
        return this.permissions;
    }

    public void reset() {
        this.name.reset();
        this.color.reset();
        this.hoisted.reset();
        this.mentionable.reset();
        this.permissions.reset();
    }

    @CheckReturnValue
    public AuditableRestAction<Void> update() {
        this.checkPermission(Permission.MANAGE_ROLES);
        this.checkPosition();
        if (!this.needsUpdate()) {
            return new AuditableRestAction.EmptyRestAction<Object>(this.getJDA(), null);
        }
        JSONObject body = new JSONObject().put("name", this.role.getName());
        if (this.name.shouldUpdate()) {
            body.put("name", this.name.getValue());
        }
        if (this.color.shouldUpdate()) {
            body.put("color", this.color.getValue() == null ? 0 : ((Color)this.color.getValue()).getRGB() & 0xFFFFFF);
        }
        if (this.hoisted.shouldUpdate()) {
            body.put("hoist", (Boolean)this.hoisted.getValue());
        }
        if (this.mentionable.shouldUpdate()) {
            body.put("mentionable", (Boolean)this.mentionable.getValue());
        }
        if (this.permissions.shouldUpdate()) {
            body.put("permissions", this.permissions.getValue());
        }
        this.reset();
        Route.CompiledRoute route = Route.Roles.MODIFY_ROLE.compile(this.getGuild().getId(), this.role.getId());
        return new AuditableRestAction<Void>(this.getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    protected boolean needsUpdate() {
        return this.name.shouldUpdate() || this.color.shouldUpdate() || this.hoisted.shouldUpdate() || this.mentionable.shouldUpdate() || this.permissions.shouldUpdate();
    }

    protected void checkPermission(Permission perm) {
        if (!this.getGuild().getSelfMember().hasPermission(perm)) {
            throw new InsufficientPermissionException(perm);
        }
    }

    protected void checkPosition() {
        if (!this.getGuild().getSelfMember().canInteract(this.role)) {
            throw new HierarchyException("Can't modify role >= highest self-role");
        }
    }

    protected void setupFields() {
        this.name = new RoleField<String>(this, this.role::getName){

            @Override
            public void checkValue(String value) {
                Checks.notNull(value, "name");
                if (value.isEmpty() || value.length() > 32) {
                    throw new IllegalArgumentException("Provided role name must be 1 to 32 characters in length");
                }
            }
        };
        this.color = new RoleField<Color>(this, this.role::getColor){

            @Override
            public RoleManagerUpdatable setValue(Color color) {
                if (color != null && color.getRGB() == 0) {
                    color = null;
                }
                super.setValue(color);
                return (RoleManagerUpdatable)this.manager;
            }

            @Override
            public void checkValue(Color value) {
            }
        };
        this.hoisted = new RoleField<Boolean>(this, this.role::isHoisted){

            @Override
            public void checkValue(Boolean value) {
                Checks.notNull(value, "hoisted Boolean");
            }
        };
        this.mentionable = new RoleField<Boolean>(this, this.role::isMentionable){

            @Override
            public void checkValue(Boolean value) {
                Checks.notNull(value, "mentionable Boolean");
            }
        };
        this.permissions = new PermissionField(this, this.role::getPermissionsRaw);
    }
}

