/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.hooks;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.Event;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.hooks.EventListener;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.hooks.IEventManager;

public class InterfacedEventManager
implements IEventManager {
    private final CopyOnWriteArrayList<EventListener> listeners = new CopyOnWriteArrayList();

    @Override
    public void register(Object listener) {
        if (!(listener instanceof EventListener)) {
            throw new IllegalArgumentException("Listener must implement EventListener");
        }
        this.listeners.add((EventListener)listener);
    }

    @Override
    public void unregister(Object listener) {
        this.listeners.remove(listener);
    }

    @Override
    public List<Object> getRegisteredListeners() {
        return Collections.unmodifiableList(new LinkedList<EventListener>(this.listeners));
    }

    @Override
    public void handle(Event event) {
        for (EventListener listener : this.listeners) {
            try {
                listener.onEvent(event);
            }
            catch (Throwable throwable) {
                JDAImpl.LOG.fatal("One of the EventListeners had an uncaught exception");
                JDAImpl.LOG.log(throwable);
            }
        }
    }
}

