/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle;

import net.shadowfacts.discordchat.gnu.trove.iterator.TLongIterator;
import net.shadowfacts.discordchat.gnu.trove.map.TLongObjectMap;
import net.shadowfacts.discordchat.gnu.trove.set.hash.TLongHashSet;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.Group;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.Relationship;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.RelationshipType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.impl.JDAClientImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.AccountType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.audio.hooks.ConnectionStatus;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.PrivateChannelImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.UserImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.guild.GuildLeaveEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.guild.GuildUnavailableEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.SocketHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class GuildDeleteHandler
extends SocketHandler {
    public GuildDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long id = content.getLong("id");
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(id);
        if ((guild == null || !guild.isAvailable()) && content.has("unavailable") && content.getBoolean("unavailable")) {
            return null;
        }
        if (this.api.getGuildLock().isLocked(id)) {
            return id;
        }
        if (content.has("unavailable") && content.getBoolean("unavailable")) {
            guild.setAvailable(false);
            this.api.getEventManager().handle(new GuildUnavailableEvent(this.api, this.responseNumber, guild));
            return null;
        }
        TLongObjectMap<AudioManagerImpl> audioManagerMap = this.api.getAudioManagerMap();
        AudioManagerImpl manager = audioManagerMap.remove(id);
        if (manager != null) {
            manager.closeAudioConnection(ConnectionStatus.DISCONNECTED_REMOVED_FROM_GUILD);
        }
        TLongHashSet memberIds = new TLongHashSet(guild.getMembersMap().keySet());
        for (Guild guildI : this.api.getGuilds()) {
            GuildImpl g = (GuildImpl)guildI;
            if (g.equals(guild)) continue;
            TLongIterator it = memberIds.iterator();
            while (it.hasNext()) {
                if (!g.getMembersMap().containsKey(it.next())) continue;
                it.remove();
            }
        }
        if (this.api.getAccountType() == AccountType.CLIENT) {
            TLongObjectMap<Relationship> relationships = ((JDAClientImpl)this.api.asClient()).getRelationshipMap();
            TLongIterator it = memberIds.iterator();
            while (it.hasNext()) {
                Relationship rel = relationships.get(it.next());
                if (rel == null || rel.getType() != RelationshipType.FRIEND) continue;
                it.remove();
            }
        }
        long selfId = this.api.getSelfUser().getIdLong();
        memberIds.forEach(memberId -> {
            if (memberId == selfId) {
                return true;
            }
            UserImpl user = (UserImpl)this.api.getUserMap().remove(memberId);
            if (user.hasPrivateChannel()) {
                PrivateChannelImpl priv = (PrivateChannelImpl)user.getPrivateChannel();
                user.setFake(true);
                priv.setFake(true);
                this.api.getFakeUserMap().put(user.getIdLong(), user);
                this.api.getFakePrivateChannelMap().put(priv.getIdLong(), priv);
            } else if (this.api.getAccountType() == AccountType.CLIENT) {
                for (Group grp : this.api.asClient().getGroups()) {
                    if (!grp.getNonFriendUsers().contains(user)) continue;
                    user.setFake(true);
                    this.api.getFakeUserMap().put(user.getIdLong(), user);
                    break;
                }
            }
            return true;
        });
        this.api.getGuildMap().remove(guild.getIdLong());
        guild.getTextChannels().forEach(chan -> this.api.getTextChannelMap().remove(chan.getIdLong()));
        guild.getVoiceChannels().forEach(chan -> this.api.getVoiceChannelMap().remove(chan.getIdLong()));
        this.api.getEventManager().handle(new GuildLeaveEvent(this.api, this.responseNumber, guild));
        return null;
    }
}

