/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities;

import java.awt.Color;
import java.time.OffsetDateTime;
import java.util.List;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.AccountType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.EmbedType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.Checks;

public interface MessageEmbed {
    public static final int TITLE_MAX_LENGTH = 256;
    public static final int VALUE_MAX_LENGTH = 1024;
    public static final int TEXT_MAX_LENGTH = 2048;
    public static final int URL_MAX_LENGTH = 2000;
    public static final int EMBED_MAX_LENGTH_BOT = 4000;
    public static final int EMBED_MAX_LENGTH_CLIENT = 2000;

    public String getUrl();

    public String getTitle();

    public String getDescription();

    public EmbedType getType();

    public Thumbnail getThumbnail();

    public Provider getSiteProvider();

    public AuthorInfo getAuthor();

    public VideoInfo getVideoInfo();

    public Footer getFooter();

    public ImageInfo getImage();

    public List<Field> getFields();

    public Color getColor();

    public OffsetDateTime getTimestamp();

    public int getLength();

    default public boolean isSendable(AccountType type) {
        Checks.notNull((Object)type, "AccountType");
        int length = this.getLength();
        switch (type) {
            case BOT: {
                return length <= 4000;
            }
            case CLIENT: {
                return length <= 2000;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot check against AccountType '%s'!", new Object[]{type}));
    }

    public static class Field {
        protected final String name;
        protected final String value;
        protected final boolean inline;

        protected Field(String name, String value, boolean inline, boolean checked) {
            if (checked) {
                if (name == null || value == null) {
                    throw new IllegalArgumentException("Both Name and Value must be set!");
                }
                if (name.length() > 256) {
                    throw new IllegalArgumentException("Name cannot be longer than 256 characters.");
                }
                if (value.length() > 1024) {
                    throw new IllegalArgumentException("Value cannot be longer than 1024 characters.");
                }
                this.name = name.isEmpty() ? "\u200e" : name;
                this.value = value.isEmpty() ? "\u200e" : value;
                this.inline = inline;
            } else {
                this.name = name;
                this.value = value;
                this.inline = inline;
            }
        }

        public Field(String name, String value, boolean inline) {
            this(name, value, inline, true);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isInline() {
            return this.inline;
        }
    }

    public static class Footer {
        protected final String text;
        protected final String iconUrl;
        protected final String proxyIconUrl;

        public Footer(String text, String iconUrl, String proxyIconUrl) {
            this.text = text;
            this.iconUrl = iconUrl;
            this.proxyIconUrl = proxyIconUrl;
        }

        public String getText() {
            return this.text;
        }

        public String getIconUrl() {
            return this.iconUrl;
        }

        public String getProxyIconUrl() {
            return this.proxyIconUrl;
        }
    }

    public static class AuthorInfo {
        protected final String name;
        protected final String url;
        protected final String iconUrl;
        protected final String proxyIconUrl;

        public AuthorInfo(String name, String url, String iconUrl, String proxyIconUrl) {
            this.name = name;
            this.url = url;
            this.iconUrl = iconUrl;
            this.proxyIconUrl = proxyIconUrl;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public String getIconUrl() {
            return this.iconUrl;
        }

        public String getProxyIconUrl() {
            return this.proxyIconUrl;
        }
    }

    public static class ImageInfo {
        protected final String url;
        protected final String proxyUrl;
        protected final int width;
        protected final int height;

        public ImageInfo(String url, String proxyUrl, int width, int height) {
            this.url = url;
            this.proxyUrl = proxyUrl;
            this.width = width;
            this.height = height;
        }

        public String getUrl() {
            return this.url;
        }

        public String getProxyUrl() {
            return this.proxyUrl;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }

    public static class VideoInfo {
        protected final String url;
        protected final int width;
        protected final int height;

        public VideoInfo(String url, int width, int height) {
            this.url = url;
            this.width = width;
            this.height = height;
        }

        public String getUrl() {
            return this.url;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }

    public static class Provider {
        protected final String name;
        protected final String url;

        public Provider(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }
    }

    public static class Thumbnail {
        protected final String url;
        protected final String proxyUrl;
        protected final int width;
        protected final int height;

        public Thumbnail(String url, String proxyUrl, int width, int height) {
            this.url = url;
            this.proxyUrl = proxyUrl;
            this.width = width;
            this.height = height;
        }

        public String getUrl() {
            return this.url;
        }

        public String getProxyUrl() {
            return this.proxyUrl;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

