/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.audio;

import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.shadowfacts.discordchat.repack.com.iwebpp.crypto.TweetNaclFast;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.audio.AudioConnection;

public class AudioPacket {
    public static final int RTP_HEADER_BYTE_LENGTH = 12;
    public static final int XSALSA20_NONCE_LENGTH = 24;
    public static final byte RTP_VERSION_PAD_EXTEND = -128;
    public static final byte RTP_PAYLOAD_TYPE = 120;
    public static final int RTP_VERSION_PAD_EXTEND_INDEX = 0;
    public static final int RTP_PAYLOAD_INDEX = 1;
    public static final int SEQ_INDEX = 2;
    public static final int TIMESTAMP_INDEX = 4;
    public static final int SSRC_INDEX = 8;
    private final char seq;
    private final int timestamp;
    private final int ssrc;
    private final byte[] encodedAudio;
    private final byte[] rawPacket;

    public AudioPacket(DatagramPacket packet) {
        this(Arrays.copyOf(packet.getData(), packet.getLength()));
    }

    public AudioPacket(byte[] rawPacket) {
        this.rawPacket = rawPacket;
        ByteBuffer buffer = ByteBuffer.wrap(rawPacket);
        this.seq = buffer.getChar(2);
        this.timestamp = buffer.getInt(4);
        this.ssrc = buffer.getInt(8);
        byte versionPad = buffer.get(0);
        byte[] data = buffer.array();
        if ((versionPad & 0x10) != 0 && data[12] == -66 && data[13] == -34) {
            int i;
            short headerLength = (short)(data[14] << 8 | data[15]);
            for (i = 16; i < headerLength + 12 + 4; ++i) {
                byte len = (byte)((data[i] & 0xF) + 1);
                i += len;
            }
            while (data[i] == 0) {
                ++i;
            }
            this.encodedAudio = new byte[data.length - i];
            System.arraycopy(data, i, this.encodedAudio, 0, this.encodedAudio.length);
        } else {
            this.encodedAudio = new byte[buffer.array().length - 12];
            System.arraycopy(buffer.array(), 12, this.encodedAudio, 0, this.encodedAudio.length);
        }
    }

    public AudioPacket(char seq, int timestamp, int ssrc, byte[] encodedAudio) {
        this.seq = seq;
        this.ssrc = ssrc;
        this.timestamp = timestamp;
        this.encodedAudio = encodedAudio;
        ByteBuffer buffer = ByteBuffer.allocate(12 + encodedAudio.length);
        buffer.put(0, (byte)-128);
        buffer.put(1, (byte)120);
        buffer.putChar(2, seq);
        buffer.putInt(4, timestamp);
        buffer.putInt(8, ssrc);
        System.arraycopy(encodedAudio, 0, buffer.array(), 12, encodedAudio.length);
        this.rawPacket = buffer.array();
    }

    public byte[] getNonce() {
        return Arrays.copyOf(this.rawPacket, 12);
    }

    public byte[] getRawPacket() {
        return Arrays.copyOf(this.rawPacket, this.rawPacket.length);
    }

    public byte[] getEncodedAudio() {
        return Arrays.copyOf(this.encodedAudio, this.encodedAudio.length);
    }

    public char getSequence() {
        return this.seq;
    }

    public int getSSRC() {
        return this.ssrc;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public DatagramPacket asUdpPacket(InetSocketAddress address) {
        return new DatagramPacket(this.getRawPacket(), this.rawPacket.length, address);
    }

    public DatagramPacket asEncryptedUdpPacket(InetSocketAddress address, byte[] secretKey) {
        byte[] extendedNonce = new byte[24];
        System.arraycopy(this.getNonce(), 0, extendedNonce, 0, 12);
        TweetNaclFast.SecretBox boxer = new TweetNaclFast.SecretBox(secretKey);
        byte[] encryptedAudio = boxer.box(this.encodedAudio, extendedNonce);
        return new AudioPacket(this.seq, this.timestamp, this.ssrc, encryptedAudio).asUdpPacket(address);
    }

    public static AudioPacket createEchoPacket(DatagramPacket packet, int ssrc) {
        ByteBuffer buffer = ByteBuffer.wrap(Arrays.copyOf(packet.getData(), packet.getLength()));
        buffer.put(0, (byte)-128);
        buffer.put(1, (byte)120);
        buffer.putInt(8, ssrc);
        return new AudioPacket(buffer.array());
    }

    public static AudioPacket decryptAudioPacket(DatagramPacket packet, byte[] secretKey) {
        TweetNaclFast.SecretBox boxer = new TweetNaclFast.SecretBox(secretKey);
        AudioPacket encryptedPacket = new AudioPacket(packet);
        byte[] extendedNonce = new byte[24];
        System.arraycopy(encryptedPacket.getNonce(), 0, extendedNonce, 0, 12);
        byte[] decryptedAudio = boxer.open(encryptedPacket.getEncodedAudio(), extendedNonce);
        if (decryptedAudio == null) {
            AudioConnection.LOG.debug("Failed to decrypt audio packet");
            return null;
        }
        byte[] decryptedRawPacket = new byte[12 + decryptedAudio.length];
        System.arraycopy(encryptedPacket.getNonce(), 0, decryptedRawPacket, 0, 12);
        System.arraycopy(decryptedAudio, 0, decryptedRawPacket, 12, decryptedAudio.length);
        return new AudioPacket(decryptedRawPacket);
    }
}

