/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.core.command.impl.minecraft;

import net.shadowfacts.discordchat.api.IConfig;
import net.shadowfacts.discordchat.api.IDiscordChat;
import net.shadowfacts.discordchat.api.IMinecraftAdapter;
import net.shadowfacts.discordchat.api.command.ICommand;
import net.shadowfacts.discordchat.api.command.exception.CommandException;
import net.shadowfacts.discordchat.api.permission.Permission;
import net.shadowfacts.discordchat.core.command.exception.InvalidUsageException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;

public class CommandUnstick
implements ICommand {
    private IDiscordChat discordChat;
    private IConfig config;
    private IMinecraftAdapter minecraftAdapter;

    public CommandUnstick(IDiscordChat discordChat) {
        this.discordChat = discordChat;
        this.config = discordChat.getConfig();
        this.minecraftAdapter = discordChat.getMinecraftAdapter();
    }

    @Override
    public String getName() {
        return "unstick";
    }

    @Override
    public Permission getMinimumPermission() {
        return this.config.getMinimumPermission(this.getName());
    }

    @Override
    public void execute(String[] args, User sender, MessageChannel channel) throws CommandException {
        if (args.length < 1) {
            throw new InvalidUsageException(this);
        }
        String error = this.minecraftAdapter.teleportPlayerToSpawn(args[0]);
        if (error == null) {
            this.sendResponse("Unstuck player: " + args[0], channel, this.discordChat);
        } else {
            this.sendResponse("Unable to unstick player: " + error, channel, this.discordChat);
        }
    }

    @Override
    public String getDescription() {
        return "Teleports the player with the given name to spawn";
    }

    @Override
    public String getUsage() {
        return "<player>";
    }
}

