/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.core.command.impl.minecraft;

import net.shadowfacts.discordchat.api.IConfig;
import net.shadowfacts.discordchat.api.IDiscordChat;
import net.shadowfacts.discordchat.api.IMinecraftAdapter;
import net.shadowfacts.discordchat.api.command.ICommand;
import net.shadowfacts.discordchat.api.command.exception.CommandException;
import net.shadowfacts.discordchat.api.permission.Permission;
import net.shadowfacts.discordchat.core.command.exception.InvalidUsageException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;

public class CommandTime
implements ICommand {
    private IDiscordChat discordChat;
    private IConfig config;
    private IMinecraftAdapter minecraftAdapter;

    public CommandTime(IDiscordChat discordChat) {
        this.discordChat = discordChat;
        this.config = discordChat.getConfig();
        this.minecraftAdapter = discordChat.getMinecraftAdapter();
    }

    @Override
    public String getName() {
        return "time";
    }

    @Override
    public Permission getMinimumPermission() {
        return this.config.getMinimumPermission(this.getName());
    }

    @Override
    public void execute(String[] args, User sender, MessageChannel channel) throws CommandException {
        int dimension;
        switch (args.length) {
            case 0: {
                dimension = 0;
                break;
            }
            case 1: {
                dimension = Integer.parseInt(args[0]);
                break;
            }
            default: {
                throw new InvalidUsageException(this);
            }
        }
        long time = this.minecraftAdapter.getWorldTime(dimension) % 24000L;
        String phase = null;
        if (0L <= time && time < 1000L) {
            phase = "Dawn";
        } else if (1000L < time && time < 12000L) {
            phase = "Day";
        } else if (12000L < time && time < 13000L) {
            phase = "Dusk";
        } else if (13000L < time && time < 24000L) {
            phase = "Night";
        }
        String response = (phase == null ? "" : "**" + phase + "**: ") + time;
        this.sendResponse(response, channel, this.discordChat);
    }

    @Override
    public String getDescription() {
        return "Gets the time of day for a dimension.";
    }

    @Override
    public String getUsage() {
        return "[dimension]";
    }
}

