/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.core.command.impl.minecraft;

import net.shadowfacts.discordchat.api.IConfig;
import net.shadowfacts.discordchat.api.IDiscordChat;
import net.shadowfacts.discordchat.api.IMinecraftAdapter;
import net.shadowfacts.discordchat.api.command.ICommand;
import net.shadowfacts.discordchat.api.command.exception.CommandException;
import net.shadowfacts.discordchat.api.permission.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;

public class CommandTPS
implements ICommand {
    private IDiscordChat discordChat;
    private IConfig config;
    private IMinecraftAdapter minecraftAdapter;

    public CommandTPS(IDiscordChat discordChat) {
        this.discordChat = discordChat;
        this.config = discordChat.getConfig();
        this.minecraftAdapter = discordChat.getMinecraftAdapter();
    }

    @Override
    public String getName() {
        return "tps";
    }

    @Override
    public Permission getMinimumPermission() {
        return this.config.getMinimumPermission(this.getName());
    }

    @Override
    public void execute(String[] args, User sender, MessageChannel channel) throws CommandException {
        if (args.length == 0) {
            StringBuilder message = new StringBuilder();
            for (int dim : this.minecraftAdapter.getAllDimensions()) {
                double tickTime = this.minecraftAdapter.getTickTime(dim);
                double tps = Math.min(1000.0 / tickTime, 20.0);
                message.append(String.format("Dimension %d: Tick time: %.3fms TPS: %.0f\n", dim, tickTime, tps));
            }
            this.sendResponse(message.toString(), channel, this.discordChat);
        } else {
            int dim;
            try {
                dim = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                throw new CommandException(e);
            }
            double tickTime = this.minecraftAdapter.getTickTime(dim);
            double tps = Math.min(tickTime / 1000.0, 20.0);
            this.sendResponse(String.format("Dimension %d: Tick time: %.3fms TPS: %.0f", dim, tickTime, tps), channel, this.discordChat);
        }
    }

    @Override
    public String getDescription() {
        return "Displays TPS for a given dimension (or all dimensions, if none is specified)";
    }

    @Override
    public String getUsage() {
        return "[dimension]";
    }
}

