/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.core.command.impl.minecraft;

import java.util.Set;
import net.shadowfacts.discordchat.api.IConfig;
import net.shadowfacts.discordchat.api.IDiscordChat;
import net.shadowfacts.discordchat.api.IMinecraftAdapter;
import net.shadowfacts.discordchat.api.command.ICommand;
import net.shadowfacts.discordchat.api.command.exception.CommandException;
import net.shadowfacts.discordchat.api.permission.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;

public class CommandOnline
implements ICommand {
    private IDiscordChat discordChat;
    private IConfig config;
    private IMinecraftAdapter minecraftAdapter;

    public CommandOnline(IDiscordChat discordChat) {
        this.discordChat = discordChat;
        this.config = discordChat.getConfig();
        this.minecraftAdapter = discordChat.getMinecraftAdapter();
    }

    @Override
    public String getName() {
        return "online";
    }

    @Override
    public Permission getMinimumPermission() {
        return this.config.getMinimumPermission(this.getName());
    }

    @Override
    public void execute(String[] args, User sender, MessageChannel channel) throws CommandException {
        Set<String> players = this.minecraftAdapter.getOnlinePlayers();
        int count = players.size();
        String s = count == 1 ? "player" : "players";
        this.sendResponse(count + " " + s + " online: " + String.join((CharSequence)", ", players), channel, this.discordChat);
    }

    @Override
    public String getDescription() {
        return "Lists all online players";
    }

    @Override
    public String getUsage() {
        return "";
    }
}

