/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.restaction;

import javax.annotation.CheckReturnValue;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Icon;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Webhook;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Response;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.Checks;
import net.shadowfacts.discordchat.repack.okhttp3.RequestBody;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class WebhookAction
extends AuditableRestAction<Webhook> {
    protected String name;
    protected Icon avatar = null;

    public WebhookAction(JDA api, Route.CompiledRoute route, String name) {
        super(api, route);
        this.name = name;
    }

    @CheckReturnValue
    public WebhookAction setName(String name) {
        Checks.notNull(name, "Webhook name");
        if (name.length() < 2 || name.length() > 100) {
            throw new IllegalArgumentException("The webhook name must be in the range of 2-100!");
        }
        this.name = name;
        return this;
    }

    @CheckReturnValue
    public WebhookAction setAvatar(Icon icon) {
        this.avatar = icon;
        return this;
    }

    @Override
    public RequestBody finalizeData() {
        JSONObject object = new JSONObject();
        object.put("name", this.name);
        object.put("avatar", this.avatar != null ? this.avatar.getEncoding() : JSONObject.NULL);
        return this.getRequestBody(object);
    }

    @Override
    protected void handleResponse(Response response, Request<Webhook> request) {
        if (!response.isOk()) {
            request.onFailure(response);
            return;
        }
        JSONObject json = response.getObject();
        Webhook webhook = this.api.getEntityBuilder().createWebhook(json);
        request.onSuccess(webhook);
    }
}

