/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle;

import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.audio.AudioConnection;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.audio.AudioWebSocket;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.SocketHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.WebSocketClient;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class VoiceServerUpdateHandler
extends SocketHandler {
    public VoiceServerUpdateHandler(JDAImpl api) {
        super(api);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Long handleInternally(JSONObject content) {
        long guildId = content.getLong("guild_id");
        this.api.getClient().getQueuedAudioConnectionMap().remove(guildId);
        if (this.api.getGuildLock().isLocked(guildId)) {
            return guildId;
        }
        if (content.isNull("endpoint")) {
            return null;
        }
        String endpoint = content.getString("endpoint");
        String token = content.getString("token");
        Guild guild = this.api.getGuildMap().get(guildId);
        if (guild == null) {
            throw new IllegalArgumentException("Attempted to start audio connection with Guild that doesn't exist! JSON: " + content);
        }
        String sessionId = guild.getSelfMember().getVoiceState().getSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Attempted to create audio connection without having a session ID. Did VOICE_STATE_UPDATED fail?");
        }
        endpoint = endpoint.replace(":80", "");
        AudioManagerImpl audioManager = (AudioManagerImpl)guild.getAudioManager();
        Object object = audioManager.CONNECTION_LOCK;
        synchronized (object) {
            if (audioManager.isConnected()) {
                audioManager.prepareForRegionChange();
            }
            if (!audioManager.isAttemptingToConnect()) {
                WebSocketClient.LOG.debug("Received a VOICE_SERVER_UPDATE but JDA is not currently connected nor attempted to connect to a VoiceChannel. Assuming that this is caused by another client running on this account. Ignoring the event.");
                return null;
            }
            AudioWebSocket socket = new AudioWebSocket(audioManager.getListenerProxy(), endpoint, this.api, guild, sessionId, token, audioManager.isAutoReconnect());
            AudioConnection connection = new AudioConnection(socket, audioManager.getQueuedAudioConnection());
            audioManager.setAudioConnection(connection);
            socket.startConnection();
            return null;
        }
    }
}

