/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl;

import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Member;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Webhook;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.WebhookManager;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.WebhookManagerUpdatable;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Requester;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Response;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.webhook.WebhookClientBuilder;

public class WebhookImpl
implements Webhook {
    protected volatile WebhookManagerUpdatable managerUpdatable = null;
    protected volatile WebhookManager manager = null;
    private final Object mngLock = new Object();
    private final TextChannel channel;
    private final long id;
    private Member owner;
    private User user;
    private String token;

    public WebhookImpl(TextChannel channel, long id) {
        this.channel = channel;
        this.id = id;
    }

    @Override
    public JDA getJDA() {
        return this.channel.getJDA();
    }

    @Override
    public Guild getGuild() {
        return this.channel.getGuild();
    }

    @Override
    public TextChannel getChannel() {
        return this.channel;
    }

    @Override
    public Member getOwner() {
        return this.owner;
    }

    @Override
    public User getDefaultUser() {
        return this.user;
    }

    @Override
    public String getName() {
        return this.user.getName();
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getUrl() {
        return Requester.DISCORD_API_PREFIX + "webhooks/" + this.getId() + "/" + this.getToken();
    }

    @Override
    public AuditableRestAction<Void> delete() {
        Route.CompiledRoute route = Route.Webhooks.DELETE_TOKEN_WEBHOOK.compile(this.getId(), this.token);
        return new AuditableRestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebhookManager getManager() {
        WebhookManager mng = this.manager;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.manager;
                if (mng == null) {
                    mng = this.manager = new WebhookManager(this);
                }
            }
        }
        return mng;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebhookManagerUpdatable getManagerUpdatable() {
        WebhookManagerUpdatable mng = this.managerUpdatable;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.managerUpdatable;
                if (mng == null) {
                    mng = this.managerUpdatable = new WebhookManagerUpdatable(this);
                }
            }
        }
        return mng;
    }

    @Override
    public WebhookClientBuilder newClient() {
        return new WebhookClientBuilder(this.id, this.token);
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    public WebhookImpl setOwner(Member member) {
        this.owner = member;
        return this;
    }

    public WebhookImpl setToken(String token) {
        this.token = token;
        return this;
    }

    public WebhookImpl setUser(User user) {
        this.user = user;
        return this;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        return obj instanceof WebhookImpl && ((WebhookImpl)obj).id == this.id;
    }

    public String toString() {
        return "WH:" + this.getName() + "(" + this.id + ")";
    }
}

