/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.core.command.impl.minecraft;

import net.shadowfacts.discordchat.api.IConfig;
import net.shadowfacts.discordchat.api.IDiscordChat;
import net.shadowfacts.discordchat.api.IMinecraftAdapter;
import net.shadowfacts.discordchat.api.command.ICommand;
import net.shadowfacts.discordchat.api.command.exception.CommandException;
import net.shadowfacts.discordchat.api.permission.Permission;
import net.shadowfacts.discordchat.core.command.exception.InvalidUsageException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;

public class CommandExecute
implements ICommand {
    private IConfig config;
    private IMinecraftAdapter minecraftAdapter;

    public CommandExecute(IDiscordChat discordChat) {
        this.config = discordChat.getConfig();
        this.minecraftAdapter = discordChat.getMinecraftAdapter();
    }

    @Override
    public String getName() {
        return "exec";
    }

    @Override
    public Permission getMinimumPermission() {
        return this.config.getMinimumPermission(this.getName());
    }

    @Override
    public void execute(String[] args, User sender, MessageChannel channel) throws CommandException {
        if (args.length == 0) {
            throw new InvalidUsageException(this);
        }
        String cmd = String.join((CharSequence)" ", args);
        this.minecraftAdapter.executeCommand(cmd);
    }

    @Override
    public String getDescription() {
        return "Executes the given command in Minecraft";
    }

    @Override
    public String getUsage() {
        return "<command>";
    }
}

