/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.core.command.impl.meta;

import java.io.IOException;
import net.shadowfacts.discordchat.api.IConfig;
import net.shadowfacts.discordchat.api.IDiscordChat;
import net.shadowfacts.discordchat.api.command.ICommand;
import net.shadowfacts.discordchat.api.command.exception.CommandException;
import net.shadowfacts.discordchat.api.permission.IPermissionManager;
import net.shadowfacts.discordchat.api.permission.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;

public class CommandReload
implements ICommand {
    private IDiscordChat discordChat;
    private IConfig config;
    private IPermissionManager permissionManager;

    public CommandReload(IDiscordChat discordChat) {
        this.discordChat = discordChat;
        this.config = discordChat.getConfig();
        this.permissionManager = discordChat.getPermissionManager();
    }

    @Override
    public String getName() {
        return "reload";
    }

    @Override
    public Permission getMinimumPermission() {
        return this.config.getMinimumPermission(this.getName());
    }

    @Override
    public void execute(String[] args, User sender, MessageChannel channel) throws CommandException {
        try {
            this.config.load();
            this.permissionManager.load();
            this.sendResponse("Configuration and permissions reloaded", channel, this.discordChat);
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
    }

    @Override
    public String getDescription() {
        return "Reloads configuration and permissions";
    }

    @Override
    public String getUsage() {
        return "";
    }
}

