/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.core;

import net.shadowfacts.discordchat.api.IConfig;
import net.shadowfacts.discordchat.api.IDiscordChat;
import net.shadowfacts.discordchat.api.IMessageFormatter;
import net.shadowfacts.discordchat.api.IMinecraftAdapter;
import net.shadowfacts.discordchat.api.command.ICommandManager;
import net.shadowfacts.discordchat.core.util.NearestMCColor;
import net.shadowfacts.discordchat.repack.com.vdurmont.emoji.EmojiParser;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.message.guild.GuildMessageReceivedEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.message.priv.PrivateMessageReceivedEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.hooks.ListenerAdapter;

public class Listener
extends ListenerAdapter {
    private IConfig config;
    private ICommandManager commandManager;
    private IMessageFormatter formatter;
    private IMinecraftAdapter minecraftAdapter;

    public Listener(IDiscordChat discordChat) {
        this.config = discordChat.getConfig();
        this.commandManager = discordChat.getCommandManager();
        this.formatter = discordChat.getFormatter();
        this.minecraftAdapter = discordChat.getMinecraftAdapter();
    }

    @Override
    public void onPrivateMessageReceived(PrivateMessageReceivedEvent event) {
        String raw = event.getMessage().getRawContent();
        if (raw.startsWith(this.config.getCommandPrefix())) {
            this.commandManager.execute(raw.substring(this.config.getCommandPrefix().length()), event.getAuthor(), event.getChannel());
        }
    }

    @Override
    public void onGuildMessageReceived(GuildMessageReceivedEvent event) {
        if (event.getAuthor().equals(event.getJDA().getSelfUser())) {
            return;
        }
        if (event.getGuild().getIdLong() != this.config.getServerID().longValue()) {
            return;
        }
        if (!this.config.getChannelIDs().contains(event.getChannel().getIdLong())) {
            return;
        }
        String raw = event.getMessage().getRawContent();
        if (raw.startsWith(this.config.getCommandPrefix())) {
            this.commandManager.execute(raw.substring(this.config.getCommandPrefix().length()), event.getAuthor(), event.getChannel());
        } else {
            String channel = event.getChannel().getName();
            String color = event.getMember().getColor() == null ? this.config.getDefaultColor() : NearestMCColor.get(event.getMember().getColor().getRGB());
            String author = event.getMember().getEffectiveName().replaceAll("\\.", "_");
            String message = EmojiParser.parseToAliases(event.getMessage().getContent());
            this.minecraftAdapter.sendMessage(this.formatter.fromDiscord(channel, color, author, message));
            event.getMessage().getAttachments().forEach(it -> this.minecraftAdapter.sendMessage("Attachment: " + it.getUrl()));
        }
    }
}

