/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Requester;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.ratelimit.IBucket;
import net.shadowfacts.discordchat.repack.okhttp3.Response;

public abstract class RateLimiter {
    protected final Requester requester;
    protected final ScheduledThreadPoolExecutor pool;
    protected volatile boolean isShutdown = false;
    protected volatile ConcurrentHashMap<String, IBucket> buckets = new ConcurrentHashMap();
    protected volatile ConcurrentLinkedQueue<IBucket> submittedBuckets = new ConcurrentLinkedQueue();

    protected RateLimiter(Requester requester, int poolSize) {
        this.requester = requester;
        this.pool = new ScheduledThreadPoolExecutor(poolSize, new RateLimitThreadFactory(requester.getJDA()));
    }

    public abstract Long getRateLimit(Route.CompiledRoute var1);

    protected abstract void queueRequest(Request var1);

    protected abstract Long handleResponse(Route.CompiledRoute var1, Response var2);

    public boolean isRateLimited(Route.CompiledRoute route) {
        return this.getRateLimit(route) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IBucket> getRouteBuckets() {
        ConcurrentHashMap<String, IBucket> concurrentHashMap = this.buckets;
        synchronized (concurrentHashMap) {
            return Collections.unmodifiableList(new ArrayList<IBucket>(this.buckets.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IBucket> getQueuedRouteBuckets() {
        ConcurrentLinkedQueue<IBucket> concurrentLinkedQueue = this.submittedBuckets;
        synchronized (concurrentLinkedQueue) {
            return Collections.unmodifiableList(new ArrayList<IBucket>(this.submittedBuckets));
        }
    }

    protected void shutdown(long time, TimeUnit unit) {
        this.isShutdown = true;
        this.pool.setKeepAliveTime(time, unit);
        this.pool.allowCoreThreadTimeOut(true);
    }

    public void forceShutdown() {
        this.pool.shutdownNow();
    }

    private class RateLimitThreadFactory
    implements ThreadFactory {
        final String identifier;
        AtomicInteger threadCount = new AtomicInteger(1);

        public RateLimitThreadFactory(JDAImpl api) {
            this.identifier = api.getIdentifierString() + " RateLimit-Queue Pool";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.identifier + " - Thread " + this.threadCount.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }
}

